/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.modular;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.modular.Source;

public class AdditiveMultiSource
implements Source {
    private final List<Source> inputs = new ArrayList<Source>();
    private volatile double[] samples;

    public void connect(Source input) {
        this.inputs.add(input);
    }

    public void disconnect(Source input) {
        this.inputs.remove(input);
    }

    @Override
    public double[] generateSamples(int samplesToGenerate, Instruction instruction) {
        if (this.samples == null) {
            double[] output = new double[samplesToGenerate];
            for (Source input : this.inputs) {
                double[] samples = input.generateSamples(samplesToGenerate, instruction);
                for (int i = 0; i < samplesToGenerate; ++i) {
                    int n = i;
                    output[n] = output[n] + samples[i];
                }
            }
            this.samples = output;
        }
        return this.samples;
    }

    @Override
    public void next() {
        for (Source input : this.inputs) {
            input.next();
        }
        this.samples = null;
    }

    public void clear() {
        this.inputs.clear();
        this.next();
    }
}

