/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.polyphonic;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jevring.frequencies.v2.envelopes.ControlledEnvelope;
import net.jevring.frequencies.v2.envelopes.Phase;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.input.KeyTiming;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.midi.MidiFrequencyMapper;

public class PolyphonicInput {
    private final Map<Integer, Integer> keyToSlot = new HashMap<Integer, Integer>();
    private final MidiFrequencyMapper midiFrequencyMapper;
    private final ControlledEnvelope volumeEnvelope;
    private final KeyTimings keyTimings;
    private final int numberOfVoices;

    public PolyphonicInput(MidiFrequencyMapper midiFrequencyMapper, ControlledEnvelope volumeEnvelope, KeyTimings keyTimings, int numberOfVoices) {
        this.volumeEnvelope = volumeEnvelope;
        this.midiFrequencyMapper = midiFrequencyMapper;
        this.keyTimings = keyTimings;
        this.numberOfVoices = numberOfVoices;
    }

    public List<Instruction> currentInput() {
        List instructions = this.keyTimings.keys().stream().map(this::keyTimingToInstruction).filter(Objects::nonNull).sorted(Comparator.comparing(Instruction::getAge)).limit(this.numberOfVoices).collect(Collectors.toList());
        ArrayList<Instruction> slottedInstructions = new ArrayList<Instruction>(this.numberOfVoices);
        for (int slot = 0; slot < this.numberOfVoices; ++slot) {
            slottedInstructions.add(null);
        }
        Iterator iterator = instructions.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            Integer slot = this.keyToSlot.get(instruction.getKey());
            if (slot == null) continue;
            slottedInstructions.set(slot, instruction);
            iterator.remove();
        }
        for (Instruction instruction : instructions) {
            for (int slot = 0; slot < this.numberOfVoices; ++slot) {
                Instruction slottedInstruction = (Instruction)slottedInstructions.get(slot);
                if (slottedInstruction != null) continue;
                slottedInstructions.set(slot, this.toNew(instruction));
            }
        }
        this.keyToSlot.clear();
        for (int slot = 0; slot < this.numberOfVoices; ++slot) {
            Instruction instruction;
            instruction = (Instruction)slottedInstructions.get(slot);
            if (instruction == null) continue;
            this.keyToSlot.put(instruction.getKey(), slot);
        }
        return slottedInstructions;
    }

    private Instruction keyTimingToInstruction(KeyTiming keyTiming) {
        int key = keyTiming.key();
        double frequency = this.midiFrequencyMapper.frequencyOf(key);
        long age = keyTiming.nanosecondsActivated() + keyTiming.nanosecondsDeactivated();
        Phase volumeEnvelopePhase = this.volumeEnvelope.phase(keyTiming.nanosecondsActivated(), keyTiming.nanosecondsDeactivated());
        if (volumeEnvelopePhase != Phase.IDLE) {
            return new Instruction(key, age, frequency, false, volumeEnvelopePhase, keyTiming.nanosecondsActivated(), keyTiming.nanosecondsDeactivated(), keyTiming.velocity(), keyTiming.lastTimeDown());
        }
        return null;
    }

    private Instruction toNew(Instruction instruction) {
        return new Instruction(instruction.getKey(), instruction.getAge(), instruction.getFrequency(), true, instruction.getVolumeEnvelopePhase(), instruction.getNanosecondsActivated(), instruction.getNanosecondsDeactivated(), instruction.getVelocity(), instruction.getTimeDown());
    }
}

