/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.monophonic;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.Phase;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.input.KeyTiming;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.midi.MidiFrequencyMapper;
import net.jevring.frequencies.v2.math.Interpolation;

public class MonophonicInput {
    private static final long MAX_GLIDE_LENGTH_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final MidiFrequencyMapper midiFrequencyMapper;
    private final Envelope volumeEnvelope;
    private final Control glideLengthControl;
    private final BooleanControl legato;
    private final KeyTimings keyTimings;
    private volatile double previousToneFrequency = 0.0;
    private volatile Instruction previousInstruction = null;

    public MonophonicInput(MidiFrequencyMapper midiFrequencyMapper, Envelope volumeEnvelope, KeyTimings keyTimings, Controls controls) {
        this.volumeEnvelope = volumeEnvelope;
        this.glideLengthControl = controls.getControl("glide-length");
        this.legato = controls.getBooleanControl("legato");
        this.midiFrequencyMapper = midiFrequencyMapper;
        this.keyTimings = keyTimings;
    }

    public Optional<Instruction> currentInput() {
        Optional<Instruction> instruction = this.keyTimings.keys().stream().map(this::keyTimingToInstruction).filter(Objects::nonNull).min(Comparator.comparing(Instruction::isInVolumeRelease).thenComparing(Instruction::getAge)).map(this::markEnvelopeResetIfDifferentFromPrevious).map(this::applyGlide);
        if (instruction.isEmpty()) {
            this.previousToneFrequency = 0.0;
            this.previousInstruction = null;
        }
        return instruction;
    }

    private Instruction markEnvelopeResetIfDifferentFromPrevious(Instruction instruction) {
        if (this.previousInstruction == null || this.previousInstruction.getKey() != instruction.getKey() || this.previousInstruction.getTimeDown() != instruction.getTimeDown()) {
            boolean newInstruction = this.previousInstruction == null || !this.legato.get();
            this.previousInstruction = instruction;
            return new Instruction(instruction.getKey(), instruction.getAge(), instruction.getFrequency(), newInstruction, instruction.getVolumeEnvelopePhase(), instruction.getNanosecondsActivated(), instruction.getNanosecondsDeactivated(), instruction.getVelocity(), instruction.getTimeDown());
        }
        return instruction;
    }

    private Instruction applyGlide(Instruction instruction) {
        double glideValue = this.glideLengthControl.getCurrentValue();
        if (glideValue > 0.0) {
            double frequency = instruction.getFrequency();
            long age = instruction.getAge();
            long maxGlideLength = (long)((double)MAX_GLIDE_LENGTH_NANOS * glideValue);
            if (this.previousToneFrequency > 0.0 && this.previousToneFrequency != frequency && age < maxGlideLength) {
                frequency = Interpolation.linear(0.0, maxGlideLength, age, this.previousToneFrequency, frequency);
            } else {
                this.previousToneFrequency = frequency;
            }
            return new Instruction(instruction.getKey(), instruction.getAge(), frequency, instruction.isNewInstruction(), instruction.getVolumeEnvelopePhase(), instruction.getNanosecondsActivated(), instruction.getNanosecondsDeactivated(), instruction.getVelocity(), instruction.getTimeDown());
        }
        return instruction;
    }

    private Instruction keyTimingToInstruction(KeyTiming keyTiming) {
        int key = keyTiming.key();
        double frequency = this.midiFrequencyMapper.frequencyOf(key);
        long age = keyTiming.nanosecondsActivated() + keyTiming.nanosecondsDeactivated();
        Phase volumeEnvelopePhase = this.volumeEnvelope.phase(keyTiming.nanosecondsActivated(), keyTiming.nanosecondsDeactivated());
        if (volumeEnvelopePhase != Phase.IDLE) {
            return new Instruction(key, age, frequency, false, volumeEnvelopePhase, keyTiming.nanosecondsActivated(), keyTiming.nanosecondsDeactivated(), keyTiming.velocity(), keyTiming.lastTimeDown());
        }
        return null;
    }
}

