/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.midi;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.midi.MidiKey;
import net.jevring.frequencies.v2.input.midi.MidiMappings;
import net.jevring.frequencies.v2.input.midi.MidiNoteListener;
import net.jevring.frequencies.v2.input.tempo.MidiClockTempoSource;

public class MidiReceiver
implements Receiver {
    private static final boolean DEBUG = false;
    private final Set<Integer> noteChannels = new HashSet<Integer>();
    private final Map<Integer, String> commands = new HashMap<Integer, String>();
    private final MidiClockTempoSource midiClockTempoSource;
    private final MidiMappings midiMappings;
    private final KeyTimings keyTimings;
    private volatile MidiNoteListener midiNoteListener;

    public MidiReceiver(MidiMappings midiMappings, KeyTimings keyTimings, MidiClockTempoSource midiClockTempoSource) {
        this.midiMappings = midiMappings;
        this.keyTimings = keyTimings;
        this.midiNoteListener = keyTimings;
        this.midiClockTempoSource = midiClockTempoSource;
        try {
            for (Field field : ShortMessage.class.getFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !field.getType().equals(Integer.TYPE)) continue;
                int value = (Integer)field.get(ShortMessage.class);
                this.commands.put(value, field.getName());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void listenOnNoChannels() {
        this.noteChannels.clear();
    }

    public boolean listensOnNoChannels() {
        return this.noteChannels.isEmpty();
    }

    public boolean listensOnAllChannels() {
        return this.noteChannels.size() == 16;
    }

    public void listenOnAllChannels() {
        for (int channel = 1; channel <= 16; ++channel) {
            this.noteChannels.add(channel);
        }
    }

    public boolean listensToNotesOnChannel(int channel) {
        return this.noteChannels.contains(channel);
    }

    public void listenToNotesOnChannel(int channel, boolean listen) {
        if (listen) {
            this.noteChannels.add(channel);
        } else {
            this.noteChannels.remove(channel);
        }
    }

    Set<Integer> getNoteChannels() {
        return this.noteChannels;
    }

    public void listen(MidiNoteListener midiNoteListener) {
        this.midiNoteListener = midiNoteListener;
    }

    public void stopListening() {
        this.midiNoteListener = this.keyTimings;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        MidiMessage midiMessage = message;
        if (midiMessage instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            int command = shortMessage.getCommand();
            int channel = shortMessage.getChannel() + 1;
            int control = shortMessage.getData1();
            int value = shortMessage.getData2();
            int status = shortMessage.getStatus();
            try {
                if (status == 248) {
                    this.midiClockTempoSource.nextTick();
                } else if (command == 144 && this.noteChannels.contains(channel)) {
                    this.midiNoteListener.down(control, value);
                } else if (command == 128 && this.noteChannels.contains(channel)) {
                    this.midiNoteListener.up(control);
                } else if (command == 176) {
                    MidiKey midiKey = new MidiKey(channel, control);
                    Control c = this.midiMappings.getControlFor(midiKey);
                    if (c != null) {
                        c.set(0.0, value, 127.0, this);
                    } else {
                        DiscreteControl dc = this.midiMappings.getDiscreteControlFor(midiKey);
                        if (dc != null) {
                            dc.set(String.valueOf(value > 0), this);
                        }
                    }
                } else if (command == 224) {
                    int pitchBend = shortMessage.getData2() * 128 + shortMessage.getData1() - 8192;
                    this.midiMappings.getPitchBendControl().set(-8192.0, pitchBend, 8191.0, this);
                } else if (command == 160) {
                    System.out.println("polyphonic aftertouch: " + Arrays.toString(message.getMessage()));
                } else if (command == 241) {
                    System.out.println("midi time code: " + Arrays.toString(message.getMessage()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            midiMessage = message;
            if (midiMessage instanceof MetaMessage) {
                MetaMessage metaMessage = (MetaMessage)midiMessage;
                System.out.println("Got meta MIDI message " + Arrays.toString(metaMessage.getMessage()));
            } else {
                midiMessage = message;
                if (midiMessage instanceof SysexMessage) {
                    SysexMessage sysexMessage = (SysexMessage)midiMessage;
                    System.out.println("Got sysex MIDI message " + Arrays.toString(sysexMessage.getMessage()));
                } else {
                    System.out.println("Got unknown MIDI message " + Arrays.toString(message.getMessage()));
                }
            }
        }
    }

    @Override
    public void close() {
    }
}

