/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.midi;

import java.util.HashMap;
import java.util.Map;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.input.midi.MidiKey;

public class MidiMappings {
    private final Map<MidiKey, String> mappings = new HashMap<MidiKey, String>();
    private final Controls controls;
    private String mappableControl;

    public MidiMappings(Controls controls) {
        this.controls = controls;
    }

    public void map(MidiKey midiKey, String control) {
        this.mappings.put(midiKey, control);
    }

    private String listenOrGetMapping(MidiKey midiKey) {
        if (this.mappableControl != null) {
            this.mappings.put(midiKey, this.mappableControl);
            return this.mappableControl;
        }
        return this.mappings.get(midiKey);
    }

    public Control getControlFor(MidiKey midiKey) {
        String controlKey = this.listenOrGetMapping(midiKey);
        if (controlKey == null) {
            return null;
        }
        return this.controls.getControl(controlKey);
    }

    public <T> DiscreteControl getDiscreteControlFor(MidiKey midiKey) {
        String controlKey = this.listenOrGetMapping(midiKey);
        if (controlKey == null) {
            return null;
        }
        return this.controls.getDiscreteControl(controlKey);
    }

    public Control getPitchBendControl() {
        return this.controls.getControl("pitch-bend");
    }

    Map<MidiKey, String> getMappings() {
        return this.mappings;
    }

    public void listenForNewMidiMapping(String control) {
        this.mappableControl = control;
    }

    public void stopListeningForNewMidiMapping() {
        this.mappableControl = null;
    }
}

