/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.midi;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sound.midi.MidiDevice;
import net.jevring.frequencies.v2.configuration.ConfigurationReader;
import net.jevring.frequencies.v2.configuration.ConfigurationWriter;
import net.jevring.frequencies.v2.configuration.StoredConfigurationCallback;
import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.midi.MidiDevices;
import net.jevring.frequencies.v2.input.midi.MidiKey;
import net.jevring.frequencies.v2.input.midi.MidiMappings;
import net.jevring.frequencies.v2.input.midi.MidiReceiver;
import net.jevring.frequencies.v2.input.tempo.MidiClockTempoSource;

public class MidiManager {
    private final File midiPropertiesFile;
    private final MidiDevices midiDevices;
    private final MidiMappings midiMappings;
    private final MidiReceiver receiver;
    private final Map<String, MidiDevice> currentMidiDevices = new HashMap<String, MidiDevice>();
    private final BooleanControl receiveMidiClock;

    public MidiManager(Controls controls, KeyTimings keyTimings, MidiClockTempoSource midiClockTempoSource, File dotConfigDirectory) {
        this.midiMappings = new MidiMappings(controls);
        this.receiver = new MidiReceiver(this.midiMappings, keyTimings, midiClockTempoSource);
        this.midiDevices = new MidiDevices(this.receiver);
        this.receiveMidiClock = controls.getBooleanControl("receive-midi-clock-active");
        this.midiPropertiesFile = MidiManager.midiPropertiesFile(dotConfigDirectory);
    }

    private static File midiPropertiesFile(File dotConfigDirectory) {
        String midiPropertiesOverrideFilePath = System.getProperty("midi.properties.file");
        if (midiPropertiesOverrideFilePath != null) {
            System.out.println("Using midi properties override from " + midiPropertiesOverrideFilePath);
            return new File(midiPropertiesOverrideFilePath);
        }
        return new File(dotConfigDirectory, "midi.conf");
    }

    public void initializeMidi() {
        List<String> compatibleDevices;
        if (!this.midiPropertiesFile.exists()) {
            try {
                this.midiPropertiesFile.getParentFile().mkdirs();
                Files.copy(MidiManager.class.getResourceAsStream("/midi.default.conf"), this.midiPropertiesFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.midiPropertiesFile.exists()) {
            this.load(this.midiPropertiesFile);
        }
        if (this.currentMidiDevices.isEmpty() && !(compatibleDevices = this.midiDevices.compatibleDevices()).isEmpty()) {
            String firstCompatibleMidiDevice = compatibleDevices.get(0);
            System.out.println("No midi device configured. Choosing first compatible device " + firstCompatibleMidiDevice);
            MidiDevice midiDevice = this.midiDevices.open(firstCompatibleMidiDevice);
            if (midiDevice == null) {
                System.err.println("Could not open midi device " + firstCompatibleMidiDevice);
            } else {
                this.currentMidiDevices.put(firstCompatibleMidiDevice, midiDevice);
            }
            this.receiver.listenOnAllChannels();
        }
    }

    public void writeToDefaultFile() {
        this.writeToFile(this.midiPropertiesFile);
    }

    public void writeToFile(File output) {
        if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
            System.err.println("Could not create directories " + output.getParentFile());
            return;
        }
        try (ConfigurationWriter writer = new ConfigurationWriter("2", output);){
            for (String string : this.currentMidiDevices.keySet()) {
                writer.add("devices", string);
            }
            for (Map.Entry entry : this.midiMappings.getMappings().entrySet()) {
                String controlName = (String)entry.getValue();
                MidiKey midiKey = (MidiKey)entry.getKey();
                int midiChannel = midiKey.channel();
                int midiControl = midiKey.control();
                writer.add("mappings", controlName + "," + midiChannel + "," + midiControl);
            }
            writer.add("note-channels", this.receiver.getNoteChannels().stream().sorted().map(String::valueOf).collect(Collectors.joining(",")));
            writer.add("midi-clock", String.format(Locale.US, "%s,%b", "receive", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load(File input) {
        this.midiMappings.getMappings().clear();
        try {
            ConfigurationReader.read(input, new StoredConfigurationCallback(){

                @Override
                public void handle(String version, String section, String setting) {
                    if ("devices".equals(section)) {
                        System.out.println("Loading pre-configured midi device " + setting);
                        MidiManager.this.enableMidiDevice(setting, false);
                    } else if ("mappings".equals(section)) {
                        String[] parts = setting.split(",", 3);
                        String mappingName = parts[0];
                        int channel2 = Integer.parseInt(parts[1]);
                        int control = Integer.parseInt(parts[2]);
                        MidiManager.this.midiMappings.map(new MidiKey(channel2, control), mappingName);
                    } else if ("note-channels".equals(section)) {
                        MidiManager.this.receiver.getNoteChannels().clear();
                        Arrays.stream(setting.split(",")).map(Integer::parseInt).forEach(channel -> MidiManager.this.receiver.listenToNotesOnChannel((int)channel, true));
                    } else if ("midi-clock".equals(section)) {
                        String[] parts = setting.split(",", 3);
                        if ("receive".equals(parts[0])) {
                            MidiManager.this.receiveMidiClock.set(Boolean.parseBoolean(parts[1]), this);
                        }
                    } else {
                        System.err.println("Unknown MIDI setting: " + section + " -> " + setting);
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MidiDevices getMidiDevices() {
        return this.midiDevices;
    }

    public MidiMappings getMidiMappings() {
        return this.midiMappings;
    }

    public MidiReceiver getReceiver() {
        return this.receiver;
    }

    public void enableMidiDevice(String device) {
        this.enableMidiDevice(device, true);
    }

    public void disableMidiDevice(String device) {
        MidiDevice midiDevice = this.currentMidiDevices.remove(device);
        if (midiDevice == null) {
            System.err.println("Device " + device + " isn't open, so it can't be closed");
            return;
        }
        this.writeToFile(this.midiPropertiesFile);
        midiDevice.close();
    }

    private void enableMidiDevice(String device, boolean store) {
        if (this.currentMidiDevices.containsKey(device)) {
            System.err.println("Midi device " + device + " was already open");
            return;
        }
        MidiDevice midiDevice = this.midiDevices.open(device);
        if (midiDevice == null) {
            System.err.println("Could not open midi device " + device);
        } else {
            this.currentMidiDevices.put(device, midiDevice);
        }
        if (store) {
            this.writeToFile(this.midiPropertiesFile);
        }
    }

    public boolean isCurrentDevice(String compatibleDevice) {
        return this.currentMidiDevices.containsKey(compatibleDevice);
    }
}

