/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input.midi;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Transmitter;
import net.jevring.frequencies.v2.input.midi.MidiReceiver;

public class MidiDevices {
    private final MidiReceiver receiver;

    public MidiDevices(MidiReceiver receiver) {
        this.receiver = receiver;
    }

    public List<String> compatibleDevices() {
        ArrayList<String> compatibleDevices = new ArrayList<String>();
        try {
            for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                if (midiDevice.getMaxReceivers() == -1) continue;
                compatibleDevices.add(info.getName());
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        return compatibleDevices;
    }

    public MidiDevice open(String device) {
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
                if (!device.equals(info.getName()) || midiDevice.getMaxReceivers() == -1) continue;
                Transmitter transmitter = midiDevice.getTransmitter();
                transmitter.setReceiver(this.receiver);
                midiDevice.open();
                return midiDevice;
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

