/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.MappingDiscreteControl;
import net.jevring.frequencies.v2.input.InputMode;
import net.jevring.frequencies.v2.input.Instruction;
import net.jevring.frequencies.v2.input.InstructionInput;
import net.jevring.frequencies.v2.input.monophonic.MonophonicInput;
import net.jevring.frequencies.v2.input.polyphonic.PolyphonicInput;

public class SwitchableMonophonicAndPolyphonicInstructionInput
implements InstructionInput {
    private final MappingDiscreteControl<InputMode> inputMode;
    private final PolyphonicInput polyphonicInput;
    private final MonophonicInput monophonicInput;
    private final int numberOfVoices;

    public SwitchableMonophonicAndPolyphonicInstructionInput(PolyphonicInput polyphonicInput, MonophonicInput monophonicInput, Controls controls, int numberOfVoices) {
        this.inputMode = controls.getDiscreteControl("input-mode").mapping(InputMode::valueOf);
        this.polyphonicInput = polyphonicInput;
        this.monophonicInput = monophonicInput;
        this.numberOfVoices = numberOfVoices;
    }

    @Override
    public List<Instruction> inputInstructions() {
        if (this.inputMode.get() == InputMode.POLYPHONIC) {
            return this.polyphonicInput.currentInput();
        }
        ArrayList<Instruction> instructions = new ArrayList<Instruction>(this.numberOfVoices);
        for (int i = 0; i < this.numberOfVoices; ++i) {
            instructions.add(null);
        }
        Optional<Instruction> potentialInstruction = this.monophonicInput.currentInput();
        if (potentialInstruction.isPresent()) {
            Instruction instruction = potentialInstruction.get();
            instructions.set(0, instruction);
        }
        return instructions;
    }
}

