/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.jevring.frequencies.v2.input.KeyTiming;
import net.jevring.frequencies.v2.input.midi.MidiNoteListener;

public class KeyTimings
implements MidiNoteListener {
    private static final int MAX_KEYS = 128;
    private final Note[] down = new Note[128];
    private final long[] up = new long[128];

    public KeyTimings() {
        Arrays.fill(this.down, new Note(0L, 0.0));
    }

    @Override
    public void down(int key, int velocity) {
        double scaledVelocity;
        if (key < 0 || key > 127) {
            System.err.println("Got invalid key down: " + key);
            return;
        }
        if (velocity < 0 || velocity > 127) {
            System.err.println("Got invalid velocity " + velocity + ", faking full hit");
            scaledVelocity = 1.0;
        } else {
            scaledVelocity = (double)velocity / 127.0;
        }
        long nowNanos = System.nanoTime();
        this.down[key] = new Note(nowNanos, scaledVelocity);
        this.up[key] = 0L;
    }

    @Override
    public void up(int key) {
        long nowNanos;
        if (key < 0 || key > 127) {
            System.err.println("Got invalid key up: " + key);
            return;
        }
        this.up[key] = nowNanos = System.nanoTime();
    }

    public List<KeyTiming> keys() {
        long nowNanos = System.nanoTime();
        ArrayList<KeyTiming> keyTimings = new ArrayList<KeyTiming>();
        for (int key = 0; key < 128; ++key) {
            Note lastDown = this.down[key];
            long lastTimeDown = lastDown.time;
            long lastTimeUp = this.up[key];
            if (lastTimeDown > 0L && (lastTimeUp == 0L || lastTimeDown > lastTimeUp)) {
                keyTimings.add(new KeyTiming(key, lastDown.velocity, nowNanos - lastTimeDown, 0L, lastTimeDown));
                continue;
            }
            if (lastTimeUp <= 0L) continue;
            long nanosecondsDeactivated = nowNanos - lastTimeUp;
            long nanosecondsActivated = lastTimeUp - lastTimeDown;
            keyTimings.add(new KeyTiming(key, lastDown.velocity, nanosecondsActivated, nanosecondsDeactivated, lastTimeDown));
        }
        return keyTimings;
    }

    private record Note(long time, double velocity) {
        public Note(long time, double velocity) {
            this.time = time;
            if (velocity < 0.0 || velocity > 1.0) {
                System.err.println("Wrong velocity " + velocity + ", faking full hit");
                this.velocity = 1.0;
            } else {
                this.velocity = velocity;
            }
        }
    }
}

