/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.input.AbstractKeySequencer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.MonophonicSequencerStep;
import net.jevring.frequencies.v2.input.PolyphonicSequencerStep;

public abstract class AbstractPolyphonicKeySequencer<T extends PolyphonicSequencerStep<?>>
extends AbstractKeySequencer<T> {
    private final Voice[] voices;

    protected AbstractPolyphonicKeySequencer(T[] sequence, KeyTimings keyTimings, Controls controls, int voices) {
        super(sequence, keyTimings, controls);
        this.voices = new Voice[voices];
        for (int i = 0; i < voices; ++i) {
            this.voices[i] = new Voice();
        }
    }

    @Override
    public void nextTick() {
        block8: {
            block7: {
                boolean immediateStart;
                if (this.requestStopPlayingEverything.compareAndSet(true, false)) {
                    for (Voice voice : this.voices) {
                        this.stopPlayingEverything(voice);
                    }
                }
                if (immediateStart = this.immediateStart.compareAndSet(true, false)) {
                    this.tick = 0;
                    for (Voice voice : this.voices) {
                        if (voice.currentlyPlayingNotes.isEmpty()) continue;
                        this.stopPlayingEverything(voice);
                        voice.noteEndsOnTick = -1;
                    }
                } else {
                    this.tick = (this.tick + 1) % this.ppqnRate;
                }
                if (!this.active || this.tick != 0) break block7;
                this.visualizeBeat();
                if (this.steps <= 0) break block8;
                this.visualizeStep(this.currentStep);
                PolyphonicSequencerStep sequencerStep = ((PolyphonicSequencerStep[])this.sequence)[this.currentStep];
                for (int i = 0; i < this.voices.length; ++i) {
                    Voice voice = this.voices[i];
                    this.play((MonophonicSequencerStep)sequencerStep.getForVoice(i), voice);
                }
                this.currentStep = (this.currentStep + 1) % this.steps;
                if (this.currentStep != 0) break block8;
                this.nextCycle();
                break block8;
            }
            for (Voice voice : this.voices) {
                this.stop(voice, this.tick);
            }
        }
    }

    private void play(MonophonicSequencerStep monophonicSequencerStep, Voice voice) {
        if (monophonicSequencerStep.getGate() == 0.0) {
            voice.noteEndsOnTick = -1;
        } else if (monophonicSequencerStep.getGate() == 1.0) {
            voice.noteEndsOnTick = -1;
            int note = monophonicSequencerStep.getNote();
            if (!voice.currentlyPlayingNotes.contains(note)) {
                this.startPlaying(note);
                voice.currentlyPlayingNotes.add(note);
            }
        } else {
            voice.noteEndsOnTick = (int)Math.round(monophonicSequencerStep.getGate() * (double)this.ppqnRate);
            int note = monophonicSequencerStep.getNote();
            this.startPlaying(note);
            voice.currentlyPlayingNotes.add(note);
        }
    }

    private void stop(Voice voice, int tick) {
        if (tick == voice.noteEndsOnTick && !voice.currentlyPlayingNotes.isEmpty()) {
            this.stopPlayingEverything(voice);
            voice.noteEndsOnTick = -1;
        }
    }

    private void stopPlayingEverything(Voice voice) {
        if (voice.currentlyPlayingNotes.size() > 1) {
            System.out.println("There were currently " + voice.currentlyPlayingNotes.size() + " playing notes: " + voice.currentlyPlayingNotes);
        }
        Iterator<Integer> iterator = voice.currentlyPlayingNotes.iterator();
        while (iterator.hasNext()) {
            Integer currentlyPlayingNote = iterator.next();
            iterator.remove();
            this.stopPlaying(currentlyPlayingNote);
        }
    }

    private static final class Voice {
        private final List<Integer> currentlyPlayingNotes = new ArrayList<Integer>();
        private int noteEndsOnTick = -1;

        private Voice() {
        }
    }
}

