/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.input;

import java.util.concurrent.atomic.AtomicBoolean;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.hooks.SequencerVisualizer;
import net.jevring.frequencies.v2.input.KeyTimings;
import net.jevring.frequencies.v2.input.Sequencer;
import net.jevring.frequencies.v2.input.SequencerStep;
import net.jevring.frequencies.v2.util.TempoTools;

public abstract class AbstractKeySequencer<T extends SequencerStep>
implements Sequencer {
    protected final AtomicBoolean immediateStart = new AtomicBoolean();
    protected final T[] sequence;
    protected final AtomicBoolean requestStopPlayingEverything = new AtomicBoolean();
    protected final KeyTimings keyTimings;
    protected volatile boolean active;
    protected volatile int steps = 16;
    protected int ppqnRate = 24;
    protected int tick = 0;
    protected int currentStep = 0;
    protected volatile SequencerVisualizer sequencerVisualizer;

    protected AbstractKeySequencer(T[] sequence, KeyTimings keyTimings, Controls controls) {
        this.sequence = sequence;
        this.keyTimings = keyTimings;
        controls.getControl("rate").addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                AbstractKeySequencer.this.ppqnRate = TempoTools.normalize((int)newValue);
            }
        });
    }

    protected void setSteps(int steps) {
        int previousSteps = this.steps;
        this.steps = steps;
        if (previousSteps == 0) {
            this.immediateStart.set(true);
        }
    }

    protected int getSteps() {
        return this.steps;
    }

    protected T sequencerStep(int step) {
        return this.sequence[step];
    }

    protected void setActive(boolean active) {
        this.active = active;
        this.reset();
    }

    public void setSequencerVisualizer(SequencerVisualizer sequencerVisualizer) {
        this.sequencerVisualizer = sequencerVisualizer;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void reset() {
        this.currentStep = 0;
        this.requestStopPlayingEverything.set(true);
        this.immediateStart.set(true);
    }

    protected abstract void nextCycle();

    protected abstract void visualizeStep(int var1);

    protected abstract void visualizeBeat();

    protected void startPlaying(int note) {
        this.keyTimings.down(note, 127);
    }

    protected void stopPlaying(int note) {
        this.keyTimings.up(note);
    }
}

