/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;

public class Stilson4PoleLadderFilter
extends AbstractLadderFilter
implements ModulatedFilter {
    private static final double[] S_STILSON_GAINTABLE = new double[]{0.999969, 0.990082, 0.980347, 0.970764, 0.961304, 0.951996, 0.94281, 0.933777, 0.924866, 0.916077, 0.90741, 0.898865, 0.890442, 0.882141, 0.873962, 0.865906, 0.857941, 0.850067, 0.842346, 0.834686, 0.827148, 0.819733, 0.812378, 0.805145, 0.798004, 0.790955, 0.783997, 0.77713, 0.770355, 0.763672, 0.75708, 0.75058, 0.744141, 0.737793, 0.731537, 0.725342, 0.719238, 0.713196, 0.707245, 0.701355, 0.695557, 0.689819, 0.684174, 0.678558, 0.673035, 0.667572, 0.66217, 0.65686, 0.651581, 0.646393, 0.641235, 0.636169, 0.631134, 0.62619, 0.621277, 0.616425, 0.611633, 0.606903, 0.602234, 0.597626, 0.593048, 0.588531, 0.584045, 0.579651, 0.575287, 0.570953, 0.566681, 0.562469, 0.558289, 0.554169, 0.550079, 0.546051, 0.542053, 0.538116, 0.53421, 0.530334, 0.52652, 0.522736, 0.518982, 0.515289, 0.511627, 0.507996, 0.504425, 0.500885, 0.497375, 0.493896, 0.490448, 0.487061, 0.483704, 0.480377, 0.477081, 0.473816, 0.470581, 0.467377, 0.464203, 0.46109, 0.457977, 0.454926, 0.451874, 0.448883, 0.445892, 0.442932, 0.440033, 0.437134, 0.434265, 0.431427, 0.428619, 0.425842, 0.423096, 0.42038, 0.417664, 0.415009, 0.412354, 0.409729, 0.407135, 0.404572, 0.402008, 0.399506, 0.397003, 0.394501, 0.392059, 0.389618, 0.387207, 0.384827, 0.382477, 0.380127, 0.377808, 0.375488, 0.37323, 0.370972, 0.368713, 0.366516, 0.364319, 0.362122, 0.359985, 0.357849, 0.355713, 0.353607, 0.351532, 0.349457, 0.347412, 0.345398, 0.343384, 0.34137, 0.339417, 0.337463, 0.33551, 0.333588, 0.331665, 0.329773, 0.327911, 0.32605, 0.324188, 0.322357, 0.320557, 0.318756, 0.316986, 0.315216, 0.313446, 0.311707, 0.309998, 0.308289, 0.30658, 0.304901, 0.303223, 0.301575, 0.299927, 0.298309, 0.296692, 0.295074, 0.293488, 0.291931, 0.290375, 0.288818, 0.287262, 0.285736, 0.284241, 0.282715, 0.28125, 0.279755, 0.27829, 0.276825, 0.275391, 0.273956, 0.272552, 0.271118, 0.269745, 0.268341, 0.266968, 0.265594, 0.264252, 0.262909, 0.261566, 0.260223, 0.258911, 0.257599, 0.256317, 0.255035, 0.25375};
    private double p;
    private double Q;
    private double[] state = new double[4];
    private double output;

    public Stilson4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
    }

    @Override
    public void reset() {
        Arrays.fill(this.state, 0.0);
        this.output = 0.0;
    }

    @Override
    public void setResonance(double r) {
        this.resonance = r = this.min(r, 1.0);
        double ix = this.p * 99.0;
        int ixint = (int)Math.floor(ix);
        double ixfrac = ix - (double)ixint;
        this.Q = r * this.lerp(ixfrac, S_STILSON_GAINTABLE[Clamp.clamp(ixint + 99, 0, 198)], S_STILSON_GAINTABLE[Clamp.clamp(ixint + 100, 0, 198)]);
    }

    @Override
    public double getMaxResonance() {
        return 1.0;
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = c;
        double fc = this.cutoffFrequency / this.sampleRate;
        double x2 = fc * fc;
        double x3 = fc * fc * fc;
        this.p = -0.69346 * x3 - 0.59515 * x2 + 3.2937 * fc - 1.0072;
        this.setResonance(this.resonance);
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialResonance = this.resonance;
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.setCutoffFrequency(Clamp.clamp(initialCutoffFrequency + frequencyModulation[s] * 20000.0, 20.0, 20000.0));
            this.setResonance(initialResonance + Interpolation.linear(0.0, 1.0, resonanceModulation[s], this.getMinResonance(), this.getMaxResonance()));
            this.loop(samples, s);
        }
        this.setCutoffFrequency(initialCutoffFrequency);
        this.setResonance(initialResonance);
        return samples;
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.loop(samples, s);
        }
        return samples;
    }

    private void loop(double[] samples, int s) {
        double in = samples[s] * (double)0.65f;
        this.output = 0.25 * (in - this.output);
        for (int pole = 0; pole < 4; ++pole) {
            double localState = this.state[pole];
            this.state[pole] = this.output = this.saturate(this.output + this.p * (this.output - localState));
            this.output = this.saturate(this.output + localState);
        }
        samples[s] = this.output = this.snapToZero(this.output);
        this.output *= this.Q;
    }
}

