/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;
import net.jevring.frequencies.v2.math.Interpolation;

public class RKSimulation4PoleLadderFilter
extends AbstractLadderFilter
implements ModulatedFilter {
    private final double[] state = new double[4];
    private final double saturation;
    private final double saturationInv = 1.0 / this.saturation;
    private final int oversampleFactor;
    private final double stepSize;

    public RKSimulation4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
        this.saturation = 3.0;
        this.oversampleFactor = 1;
        this.stepSize = 1.0 / ((double)this.oversampleFactor * sampleRate);
    }

    @Override
    public void reset() {
        Arrays.fill(this.state, 0.0);
    }

    @Override
    public void setResonance(double q) {
        super.setResonance(q);
    }

    @Override
    public double getMaxResonance() {
        return 10.0;
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = this.transformCutoffFrequency(c);
    }

    private double transformCutoffFrequency(double c) {
        return Math.PI * 2 * c;
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            double cutoffFrequency = this.cutoffFrequency + this.transformCutoffFrequency(frequencyModulation[s] * 20000.0);
            double resonance = this.resonance + Interpolation.linear(0.0, 1.0, resonanceModulation[s], this.getMinResonance(), this.getMaxResonance());
            for (int j = 0; j < this.oversampleFactor; ++j) {
                this.rungekutteSolver(samples[s], this.state, cutoffFrequency, resonance);
            }
            samples[s] = this.state[3];
        }
        return samples;
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            for (int j = 0; j < this.oversampleFactor; ++j) {
                this.rungekutteSolver(samples[s], this.state, this.cutoffFrequency, this.resonance);
            }
            samples[s] = this.state[3];
        }
        return samples;
    }

    private void calculateDerivatives(double input, double[] dstate, double[] state, double cutoffFrequency, double resonance) {
        double satstate0 = this.clip(state[0], this.saturation, this.saturationInv);
        double satstate1 = this.clip(state[1], this.saturation, this.saturationInv);
        double satstate2 = this.clip(state[2], this.saturation, this.saturationInv);
        dstate[0] = cutoffFrequency * (this.clip(input - resonance * state[3], this.saturation, this.saturationInv) - satstate0);
        dstate[1] = cutoffFrequency * (satstate0 - satstate1);
        dstate[2] = cutoffFrequency * (satstate1 - satstate2);
        dstate[3] = cutoffFrequency * (satstate2 - this.clip(state[3], this.saturation, this.saturationInv));
    }

    private void rungekutteSolver(double input, double[] state, double cutoffFrequency, double resonance) {
        int i;
        double[] deriv1 = new double[4];
        double[] deriv2 = new double[4];
        double[] deriv3 = new double[4];
        double[] deriv4 = new double[4];
        double[] tempState = new double[4];
        this.calculateDerivatives(input, deriv1, state, cutoffFrequency, resonance);
        for (i = 0; i < 4; ++i) {
            tempState[i] = state[i] + 0.5 * this.stepSize * deriv1[i];
        }
        this.calculateDerivatives(input, deriv2, tempState, cutoffFrequency, resonance);
        for (i = 0; i < 4; ++i) {
            tempState[i] = state[i] + 0.5 * this.stepSize * deriv2[i];
        }
        this.calculateDerivatives(input, deriv3, tempState, cutoffFrequency, resonance);
        for (i = 0; i < 4; ++i) {
            tempState[i] = state[i] + this.stepSize * deriv3[i];
        }
        this.calculateDerivatives(input, deriv4, tempState, cutoffFrequency, resonance);
        for (i = 0; i < 4; ++i) {
            int n = i;
            state[n] = state[n] + 0.16666666666666666 * this.stepSize * (deriv1[i] + 2.0 * deriv2[i] + 2.0 * deriv3[i] + deriv4[i]);
        }
    }
}

