/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;

public class Microtracker4PoleLadderFilter
extends AbstractLadderFilter {
    private double p0;
    private double p1;
    private double p2;
    private double p3;
    private double p32;
    private double p33;
    private double p34;

    public Microtracker4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = this.min(c * 2.0 * Math.PI / this.sampleRate, 1.0);
    }

    @Override
    public void reset() {
        this.p0 = 0.0;
        this.p1 = 0.0;
        this.p2 = 0.0;
        this.p3 = 0.0;
        this.p32 = 0.0;
        this.p33 = 0.0;
        this.p34 = 0.0;
    }

    @Override
    public double getMaxResonance() {
        return 20.0;
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        double k = this.resonance * 4.0;
        for (int s = 0; s < input.length; ++s) {
            double out = this.p3 * 0.360891 + this.p32 * 0.41729 + this.p33 * 0.177896 + this.p34 * 0.0439725;
            this.p34 = this.p33;
            this.p33 = this.p32;
            this.p32 = this.p3;
            this.p0 += (this.fastTanh(samples[s] - k * out) - this.fastTanh(this.p0)) * this.cutoffFrequency;
            this.p1 += (this.fastTanh(this.p0) - this.fastTanh(this.p1)) * this.cutoffFrequency;
            this.p2 += (this.fastTanh(this.p1) - this.fastTanh(this.p2)) * this.cutoffFrequency;
            this.p3 += (this.fastTanh(this.p2) - this.fastTanh(this.p3)) * this.cutoffFrequency;
            samples[s] = out;
        }
        return samples;
    }
}

