/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.moogladders.ladder;

import java.util.Arrays;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.AbstractLadderFilter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.math.Interpolation;

public class Krajeski4PoleLadderFilter
extends AbstractLadderFilter
implements ModulatedFilter {
    private double wc;
    private double g;
    private double gRes;
    private double gComp = 1.0;
    private double drive = 1.0;
    private double[] delay = new double[5];
    private double[] state = new double[5];

    public Krajeski4PoleLadderFilter(double sampleRate) {
        super(sampleRate);
    }

    @Override
    public void reset() {
        Arrays.fill(this.state, 0.0);
        Arrays.fill(this.delay, 0.0);
    }

    @Override
    public void setResonance(double r) {
        this.resonance = r;
        this.gRes = this.resonance * (1.0029 + 0.0526 * this.wc - 0.926 * Math.pow(this.wc, 2.0) + 0.0218 * Math.pow(this.wc, 3.0));
    }

    @Override
    public double getMaxResonance() {
        return 20.0;
    }

    @Override
    public void setCutoffFrequency(double c) {
        this.cutoffFrequency = c;
        this.wc = Math.PI * 2 * this.cutoffFrequency / this.sampleRate;
        this.g = 0.9892 * this.wc - 0.4342 * Math.pow(this.wc, 2.0) + 0.1381 * Math.pow(this.wc, 3.0) - 0.0202 * Math.pow(this.wc, 4.0);
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialResonance = this.resonance;
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.setCutoffFrequency(Clamp.clamp(initialCutoffFrequency + frequencyModulation[s] * 20000.0, 20.0, 20000.0));
            this.setResonance(initialResonance + Interpolation.linear(0.0, 1.0, resonanceModulation[s], this.getMinResonance(), this.getMaxResonance()));
            this.loop(samples, s);
        }
        this.setCutoffFrequency(initialCutoffFrequency);
        this.setResonance(initialResonance);
        return samples;
    }

    @Override
    public double[] apply(double[] input) {
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int s = 0; s < input.length; ++s) {
            this.loop(samples, s);
        }
        return samples;
    }

    private void loop(double[] samples, int s) {
        this.state[0] = Math.tanh(this.drive * (samples[s] - 4.0 * this.gRes * (this.state[4] - this.gComp * samples[s])));
        for (int i = 0; i < 4; ++i) {
            this.state[i + 1] = this.g * (0.23076923076923075 * this.state[i] + 0.7692307692307692 * this.delay[i] - this.state[i + 1]) + this.state[i + 1];
            this.delay[i] = this.state[i];
        }
        samples[s] = this.state[4];
    }
}

