/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.juce;

import net.jevring.frequencies.v2.filters.juce.AbstractIIRFilter;

public class LowPassJuceIIRFilter
extends AbstractIIRFilter {
    public LowPassJuceIIRFilter(double sampleRate) {
        super(sampleRate);
    }

    @Override
    protected void configure(double cutoffFrequency, double Q) {
        double n = 1.0 / Math.tan(Math.PI * cutoffFrequency / this.sampleRate);
        double nSquared = n * n;
        double c1 = 1.0 / (1.0 + 1.0 / Q * n + nSquared);
        this.setCoefficients(new AbstractIIRFilter.Coefficients(c1, c1 * 2.0, c1, c1 * 2.0 * (1.0 - nSquared), c1 * (1.0 - 1.0 / Q * n + nSquared)));
    }
}

