/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.juce;

import net.jevring.frequencies.v2.filters.juce.AbstractIIRFilter;

public class HighPassJuceIIRFilter
extends AbstractIIRFilter {
    public HighPassJuceIIRFilter(double sampleRate) {
        super(sampleRate);
    }

    @Override
    protected void configure(double cutoffFrequency, double Q) {
        double n = Math.tan(Math.PI * cutoffFrequency / this.sampleRate);
        double nSquared = n * n;
        double c1 = 1.0 / (1.0 + 1.0 / Q * n + nSquared);
        this.setCoefficients(new AbstractIIRFilter.Coefficients(c1, c1 * -2.0, c1, c1 * 2.0 * (nSquared - 1.0), c1 * (1.0 - 1.0 / Q * n + nSquared)));
    }
}

