/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.juce;

import net.jevring.frequencies.v2.filters.CutoffFrequencyFilter;
import net.jevring.frequencies.v2.filters.ModulatedFilter;
import net.jevring.frequencies.v2.filters.QFilter;
import net.jevring.frequencies.v2.math.Clamp;

public abstract class AbstractIIRFilter
implements QFilter,
CutoffFrequencyFilter,
ModulatedFilter {
    protected final double sampleRate;
    protected volatile Coefficients coefficients;
    protected volatile double v1;
    protected volatile double v2;
    private volatile double cutoffFrequency;
    private volatile double Q;

    protected AbstractIIRFilter(double sampleRate) {
        this.sampleRate = sampleRate;
        this.cutoffFrequency = sampleRate * 0.4;
        this.Q = 1.0 / Math.sqrt(2.0);
        this.configure(this.cutoffFrequency, this.Q);
    }

    protected abstract void configure(double var1, double var3);

    protected void setCoefficients(Coefficients coefficients) {
        this.coefficients = coefficients;
    }

    @Override
    public void setCutoffFrequency(double cutoffFrequency) {
        this.cutoffFrequency = cutoffFrequency;
        this.configure(cutoffFrequency, this.Q);
    }

    @Override
    public double getCutoffFrequency() {
        return this.cutoffFrequency;
    }

    @Override
    public void setResonance(double q) {
        this.Q = q;
        this.configure(this.cutoffFrequency, q);
    }

    @Override
    public double getResonance() {
        return this.Q;
    }

    @Override
    public double getMaxResonance() {
        return 10.0;
    }

    @Override
    public double[] apply(double[] input, double[] frequencyModulation, double[] resonanceModulation) {
        double initialCutoffFrequency = this.cutoffFrequency;
        double initialQ = this.Q;
        double lv1 = Double.isNaN(this.v1) ? 0.0 : this.v1;
        double lv2 = Double.isNaN(this.v2) ? 0.0 : this.v2;
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int i = 0; i < samples.length; ++i) {
            double out;
            this.configure(Clamp.clamp(initialCutoffFrequency + frequencyModulation[i] * 20000.0, 20.0, 20000.0), initialQ + resonanceModulation[i]);
            double in = samples[i];
            samples[i] = out = this.coefficients.c0 * in + lv1;
            lv1 = this.coefficients.c1 * in - this.coefficients.c3 * out + lv2;
            lv2 = this.coefficients.c2 * in - this.coefficients.c4 * out;
        }
        this.v1 = lv1;
        this.v2 = lv2;
        this.configure(initialCutoffFrequency, initialQ);
        return samples;
    }

    @Override
    public double[] apply(double[] input) {
        double lv1 = Double.isNaN(this.v1) ? 0.0 : this.v1;
        double lv2 = Double.isNaN(this.v2) ? 0.0 : this.v2;
        Coefficients localCoefficients = this.coefficients;
        double c0 = localCoefficients.c0;
        double c1 = localCoefficients.c1;
        double c2 = localCoefficients.c2;
        double c3 = localCoefficients.c3;
        double c4 = localCoefficients.c4;
        double[] samples = new double[input.length];
        System.arraycopy(input, 0, samples, 0, input.length);
        for (int i = 0; i < samples.length; ++i) {
            double out;
            double in = samples[i];
            samples[i] = out = c0 * in + lv1;
            lv1 = c1 * in - c3 * out + lv2;
            lv2 = c2 * in - c4 * out;
        }
        this.v1 = lv1;
        this.v2 = lv2;
        return samples;
    }

    @Override
    public void reset() {
        this.v1 = 0.0;
        this.v2 = 0.0;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected static final class Coefficients {
        private final double c0;
        private final double c1;
        private final double c2;
        private final double c3;
        private final double c4;

        public Coefficients(double c0, double c1, double c2, double c3, double c4) {
            this(c0, c1, c2, c3, c4, 1.0);
        }

        public Coefficients(double c0, double c1, double c2, double c3, double c4, double shelfDivisor) {
            double multiplier = 1.0 / shelfDivisor;
            this.c0 = c0 * multiplier;
            this.c1 = c1 * multiplier;
            this.c2 = c2 * multiplier;
            this.c3 = c3 * multiplier;
            this.c4 = c4 * multiplier;
        }
    }
}

