/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters.alpha;

import net.jevring.frequencies.v2.filters.alpha.AlphaFilter;

public class AlphaLowPassFilter
implements AlphaFilter {
    private volatile double alpha = 0.5;

    @Override
    public double[] apply(double[] input) {
        return this.embeddedrelated(input);
    }

    private double[] embeddedrelated(double[] input) {
        double[] output = new double[input.length];
        double yk = input[0];
        for (int i = 0; i < input.length; ++i) {
            yk += this.alpha * (input[i] - yk);
            output[i] = yk;
        }
        return output;
    }

    public double[] wikipedia(double[] input) {
        double[] output = new double[input.length];
        output[0] = this.alpha * input[0];
        for (int i = 1; i < input.length; ++i) {
            output[i] = output[i - 1] + this.alpha * (input[i] - output[i - 1]);
        }
        return output;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Alpha must be between 0 and 1");
        }
        this.alpha = alpha;
    }

    public String toString() {
        return "AlphaLowPass";
    }
}

