/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.filters;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jevring.frequencies.v2.filters.DiodeLadderFilter;
import net.jevring.frequencies.v2.filters.Filter;
import net.jevring.frequencies.v2.filters.NoopFilter;
import net.jevring.frequencies.v2.filters.juce.BandPassJuceIIRFilter;
import net.jevring.frequencies.v2.filters.juce.HighPassJuceIIRFilter;
import net.jevring.frequencies.v2.filters.juce.LowPassJuceIIRFilter;
import net.jevring.frequencies.v2.filters.moogladders.biquad.BandPassRBJFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.RKSimulation4PoleLadderFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.Simplified4PoleLadderFilter;
import net.jevring.frequencies.v2.filters.moogladders.ladder.Stilson4PoleLadderFilter;
import net.jevring.frequencies.v2.filters.open303.Open303TeeBeeFilter;

public class Filters {
    private final Map<String, Supplier<Filter>> suppliers = new LinkedHashMap<String, Supplier<Filter>>();

    public Filters(double sampleRate) {
        this.suppliers.put("Stilson4PoleLadderFilter", () -> new Stilson4PoleLadderFilter(sampleRate));
        this.suppliers.put("Simplified4PoleLadderFilter", () -> new Simplified4PoleLadderFilter(sampleRate));
        this.suppliers.put("RKSimulation4PoleLadderFilter", () -> new RKSimulation4PoleLadderFilter(sampleRate));
        this.suppliers.put("DiodeLadderFilter", () -> new DiodeLadderFilter(sampleRate));
        this.suppliers.put("LowPassJuceIIRFilter", () -> new LowPassJuceIIRFilter(sampleRate));
        this.suppliers.put("HighPassJuceIIRFilter", () -> new HighPassJuceIIRFilter(sampleRate));
        this.suppliers.put("BandPassJuceIIRFilter", () -> new BandPassJuceIIRFilter(sampleRate));
        this.suppliers.put("NoopFilter", NoopFilter::new);
        this.suppliers.put("Open303", () -> new Open303TeeBeeFilter(sampleRate));
        this.suppliers.put("BandPassRBJFilter", () -> new BandPassRBJFilter(sampleRate));
    }

    public Filter create(String name) {
        return this.suppliers.get(name).get();
    }

    public List<String> all() {
        return this.suppliers.keySet().stream().collect(Collectors.toUnmodifiableList());
    }
}

