/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.envelopes;

import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.Levels;
import net.jevring.frequencies.v2.envelopes.Phase;

public class LinearDecayEnvelope
implements DecayEnvelope,
Envelope {
    private volatile long decayInNanos = 200L;
    private Levels previous;

    @Override
    public long getDecayInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.decayInNanos);
    }

    @Override
    public void setDecayInMillis(long decay) {
        this.decayInNanos = TimeUnit.MILLISECONDS.toNanos(decay);
    }

    @Override
    public double[] levels(long nanosecondsActivated, long nanosecondsDeactivated, int samplesToGenerate, double sampleRate) {
        double originalReleaseStartingPoint = 0.0;
        double nanosPerSecond = TimeUnit.SECONDS.toNanos(1L);
        int samplesProcessed = 0;
        if (this.previous != null) {
            samplesProcessed = this.previous.getSamplesProcessed();
        }
        double[] output = new double[samplesToGenerate];
        double decayInSeconds = (double)this.decayInNanos / nanosPerSecond;
        double samplesInDecay = decayInSeconds * sampleRate;
        double decayTick = 1.0 / samplesInDecay;
        output[0] = this.previous == null ? 1.0 : this.previous.lastSample();
        for (int i = 1; i < samplesToGenerate; ++i) {
            output[i] = output[i - 1] - decayTick;
        }
        this.previous = new Levels(originalReleaseStartingPoint, samplesProcessed + samplesToGenerate, output);
        return output;
    }

    @Override
    public Phase phase(long nanosecondsActivated, long nanosecondsDeactivated) {
        if (nanosecondsActivated + nanosecondsDeactivated < this.decayInNanos) {
            return Phase.DECAY;
        }
        return Phase.IDLE;
    }

    @Override
    public void reset() {
        this.previous = null;
    }

    public String toString() {
        return "LinearDecay";
    }
}

