/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.envelopes;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v2.envelopes.AttackEnvelope;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.Levels;
import net.jevring.frequencies.v2.envelopes.Phase;
import net.jevring.frequencies.v2.envelopes.ReleaseEnvelope;
import net.jevring.frequencies.v2.envelopes.SustainEnvelope;
import net.jevring.frequencies.v2.math.Interpolation;

public class LinearADSREnvelope
implements AttackEnvelope,
DecayEnvelope,
SustainEnvelope,
ReleaseEnvelope,
Envelope {
    private long attack = LinearADSREnvelope.nanos(250L);
    private long decay = LinearADSREnvelope.nanos(250L);
    private double sustain = 0.5;
    private long release = LinearADSREnvelope.nanos(250L);
    private Levels previous;

    private static long nanos(long timeInMillis) {
        return TimeUnit.MILLISECONDS.toNanos(timeInMillis);
    }

    private static long millis(long timeInNanos) {
        return TimeUnit.NANOSECONDS.toMillis(timeInNanos);
    }

    @Override
    public long getAttackInMillis() {
        return LinearADSREnvelope.millis(this.attack);
    }

    @Override
    public void setAttackInMillis(long attack) {
        this.attack = LinearADSREnvelope.nanos(attack);
    }

    @Override
    public long getDecayInMillis() {
        return LinearADSREnvelope.millis(this.decay);
    }

    @Override
    public void setDecayInMillis(long decay) {
        this.decay = LinearADSREnvelope.nanos(decay);
    }

    @Override
    public double getSustainLevel() {
        return this.sustain;
    }

    @Override
    public void setSustainLevel(double sustain) {
        this.sustain = sustain;
    }

    @Override
    public long getReleaseInMillis() {
        return LinearADSREnvelope.millis(this.release);
    }

    @Override
    public void setReleaseInMillis(long release) {
        this.release = LinearADSREnvelope.nanos(release);
    }

    @Override
    public Phase phase(long nanosecondsActivated, long nanosecondsDeactivated) {
        if (nanosecondsDeactivated > this.release) {
            return Phase.IDLE;
        }
        if (nanosecondsDeactivated > 0L) {
            return Phase.RELEASE;
        }
        if (nanosecondsActivated < this.attack) {
            return Phase.ATTACK;
        }
        if (nanosecondsActivated < this.attack + this.decay) {
            return Phase.DECAY;
        }
        return Phase.SUSTAIN;
    }

    @Override
    public double[] levels(long nanosecondsActivated, long nanosecondsDeactivated, int samplesToGenerate, double sampleRate) {
        double originalReleaseStartingPoint = 0.0;
        double nanosPerSecond = TimeUnit.SECONDS.toNanos(1L);
        int samplesProcessed = 0;
        if (this.previous != null) {
            samplesProcessed = this.previous.getSamplesProcessed();
        }
        double[] output = new double[samplesToGenerate];
        if (nanosecondsDeactivated > 0L) {
            double v;
            double startingPointForRelease;
            if (this.previous == null || this.previous.getOriginalReleaseStartingPoint() == 0.0) {
                startingPointForRelease = nanosecondsActivated < this.attack ? this.attackLevel(nanosecondsActivated) : (nanosecondsActivated < this.attack + this.decay ? this.decayLevel(nanosecondsActivated) : this.sustain);
                originalReleaseStartingPoint = startingPointForRelease;
            } else {
                startingPointForRelease = this.previous.lastSample();
                originalReleaseStartingPoint = this.previous.getOriginalReleaseStartingPoint();
            }
            double releaseInSeconds = (double)this.release / nanosPerSecond;
            double samplesInRelease = releaseInSeconds * sampleRate;
            double releaseTick = originalReleaseStartingPoint / samplesInRelease;
            output[0] = startingPointForRelease;
            for (int i = 1; i < samplesToGenerate && !((v = output[i - 1] - releaseTick) <= 0.0); ++i) {
                output[i] = v;
            }
        } else {
            double attackInSeconds = (double)this.attack / nanosPerSecond;
            double samplesInAttack = attackInSeconds * sampleRate;
            double attackTick = 1.0 / samplesInAttack;
            double decayInSeconds = (double)this.decay / nanosPerSecond;
            double samplesInDecay = decayInSeconds * sampleRate;
            double decayTick = (1.0 - this.sustain) / samplesInDecay;
            output[0] = this.previous == null ? (nanosecondsActivated > this.attack ? 1.0 : 0.0) : this.previous.lastSample();
            for (int i = 1; i < samplesToGenerate; ++i) {
                int totalSamplesProcessed = samplesProcessed + i;
                output[i] = (double)totalSamplesProcessed <= samplesInAttack ? output[i - 1] + attackTick : ((double)totalSamplesProcessed <= samplesInAttack + samplesInDecay ? output[i - 1] - decayTick : this.sustain);
            }
        }
        this.previous = new Levels(originalReleaseStartingPoint, samplesProcessed + samplesToGenerate, output);
        return output;
    }

    @Override
    public void reset() {
        this.previous = null;
    }

    public static void main(String[] args) {
        LinearADSREnvelope envelope = new LinearADSREnvelope();
        long oneSecondInNanos = TimeUnit.SECONDS.toNanos(1L);
        int chunkSize = 441;
        double sampleRate = 44100.0;
        long chunkInNanos = (long)(0.01 * (double)oneSecondInNanos);
        int chunk = 0;
        long nanosecondsActivated = 0L;
        long nanosecondsDeactivated = 0L;
        for (int i = 0; i <= 44100; i += chunkSize) {
            double[] envelopeValues;
            if (chunk < 66) {
                nanosecondsActivated += chunkInNanos;
            } else {
                nanosecondsDeactivated += chunkInNanos;
            }
            for (double d : envelopeValues = envelope.levels(nanosecondsActivated, nanosecondsDeactivated, chunkSize, sampleRate)) {
                System.out.printf(Locale.US, "%d,%f%n", chunk, d);
            }
            ++chunk;
        }
    }

    private double decayLevel(long nanosecondsActivated) {
        return Interpolation.linear(this.attack, this.attack + this.decay, nanosecondsActivated, 1.0, this.sustain);
    }

    private double attackLevel(long nanosecondsActivated) {
        return Interpolation.linear(0.0, this.attack, nanosecondsActivated, 0.0, 1.0);
    }

    public String toString() {
        return "LinearADSR";
    }
}

