/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.envelopes;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.Levels;
import net.jevring.frequencies.v2.envelopes.LoopingEnvelope;
import net.jevring.frequencies.v2.envelopes.Phase;

public class ExponentialDecayEnvelope
implements DecayEnvelope,
LoopingEnvelope,
Envelope {
    private static final double ZEROISH = 0.01;
    private static final double LN_OF_ZEROISH = Math.log(0.01);
    private volatile long decayInNanos = 200L;
    private volatile boolean loop = false;
    private Levels previous;

    @Override
    public long getDecayInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.decayInNanos);
    }

    @Override
    public void setDecayInMillis(long decay) {
        this.decayInNanos = TimeUnit.MILLISECONDS.toNanos(decay);
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public double[] levels(long nanosecondsActivated, long nanosecondsDeactivated, int samplesToGenerate, double sampleRate) {
        double nanosPerSecond = TimeUnit.SECONDS.toNanos(1L);
        double decayInSeconds = (double)this.decayInNanos / nanosPerSecond;
        int samplesInDecay = (int)(decayInSeconds * sampleRate);
        double decayFactor = Math.exp(LN_OF_ZEROISH / (double)samplesInDecay);
        int samplesProcessed = this.previous != null ? this.previous.getSamplesProcessed() : 0;
        double[] output = new double[samplesToGenerate];
        output[0] = this.previous != null ? this.previous.lastSample() : 1.0;
        int totalSamplesProcessed = samplesProcessed;
        for (int i = 1; i < samplesToGenerate; ++i) {
            if (this.loop && totalSamplesProcessed >= samplesInDecay) {
                totalSamplesProcessed = 0;
                output[i] = 1.0;
                continue;
            }
            ++totalSamplesProcessed;
            output[i] = output[i - 1] * decayFactor;
        }
        this.previous = new Levels(Double.NaN, totalSamplesProcessed, output);
        return output;
    }

    public static void main(String[] args) {
        ExponentialDecayEnvelope envelope = new ExponentialDecayEnvelope();
        envelope.setDecayInMillis(250L);
        envelope.setLoop(true);
        long oneSecondInNanos = TimeUnit.SECONDS.toNanos(1L);
        int chunkSize = 441;
        double sampleRate = 44100.0;
        long chunkInNanos = (long)(0.01 * (double)oneSecondInNanos);
        int chunk = 0;
        long nanosecondsActivated = 0L;
        long nanosecondsDeactivated = 0L;
        for (int i = 0; i <= 44100; i += chunkSize) {
            double[] envelopeValues;
            if (chunk < 66) {
                nanosecondsActivated += chunkInNanos;
            } else {
                nanosecondsDeactivated += chunkInNanos;
            }
            for (double d : envelopeValues = envelope.levels(nanosecondsActivated, nanosecondsDeactivated, chunkSize, sampleRate)) {
                System.out.printf(Locale.US, "%f%n", d);
            }
            ++chunk;
        }
    }

    @Override
    public Phase phase(long nanosecondsActivated, long nanosecondsDeactivated) {
        if (nanosecondsActivated + nanosecondsDeactivated < this.decayInNanos || this.loop && nanosecondsDeactivated == 0L) {
            return Phase.DECAY;
        }
        return Phase.IDLE;
    }

    @Override
    public void reset() {
        this.previous = null;
    }

    public String toString() {
        return "ExponentialDecay";
    }
}

