/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.envelopes;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v2.envelopes.AttackEnvelope;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.HoldEnvelope;
import net.jevring.frequencies.v2.envelopes.Levels;
import net.jevring.frequencies.v2.envelopes.LoopingEnvelope;
import net.jevring.frequencies.v2.envelopes.Phase;

public class AttackHoldDecayEnvelope
implements AttackEnvelope,
HoldEnvelope,
DecayEnvelope,
LoopingEnvelope,
Envelope {
    private static final double ZEROISH = 0.01;
    private static final double LN_OF_ZEROISH = Math.log(0.01);
    private long attackInNanos = AttackHoldDecayEnvelope.nanos(250L);
    private long holdInNanos = AttackHoldDecayEnvelope.nanos(250L);
    private long decayInNanos = AttackHoldDecayEnvelope.nanos(250L);
    private volatile boolean loop = false;
    private Levels previous;

    private static long nanos(long timeInMillis) {
        return TimeUnit.MILLISECONDS.toNanos(timeInMillis);
    }

    private static long millis(long timeInNanos) {
        return TimeUnit.NANOSECONDS.toMillis(timeInNanos);
    }

    @Override
    public long getAttackInMillis() {
        return AttackHoldDecayEnvelope.millis(this.attackInNanos);
    }

    @Override
    public void setAttackInMillis(long attack) {
        this.attackInNanos = AttackHoldDecayEnvelope.nanos(attack);
    }

    @Override
    public long getHoldInMillis() {
        return AttackHoldDecayEnvelope.millis(this.holdInNanos);
    }

    @Override
    public void setHoldInMillis(long hold) {
        this.holdInNanos = AttackHoldDecayEnvelope.nanos(hold);
    }

    @Override
    public long getDecayInMillis() {
        return AttackHoldDecayEnvelope.millis(this.decayInNanos);
    }

    @Override
    public void setDecayInMillis(long decay) {
        this.decayInNanos = AttackHoldDecayEnvelope.nanos(decay);
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public Phase phase(long nanosecondsActivated, long nanosecondsDeactivated) {
        if (nanosecondsActivated + nanosecondsDeactivated < this.attackInNanos + this.holdInNanos + this.decayInNanos || this.loop && nanosecondsDeactivated == 0L) {
            return Phase.DECAY;
        }
        return Phase.IDLE;
    }

    @Override
    public double[] levels(long nanosecondsActivated, long nanosecondsDeactivated, int samplesToGenerate, double sampleRate) {
        double nanosPerSecond = TimeUnit.SECONDS.toNanos(1L);
        double attackInSeconds = (double)this.attackInNanos / nanosPerSecond;
        double samplesInAttack = attackInSeconds * sampleRate;
        double attackTick = 1.0 / samplesInAttack;
        double holdInSeconds = (double)this.holdInNanos / nanosPerSecond;
        double samplesInHold = holdInSeconds * sampleRate;
        double decayInSeconds = (double)this.decayInNanos / nanosPerSecond;
        double samplesInDecay = decayInSeconds * sampleRate;
        double decayFactor = Math.exp(LN_OF_ZEROISH / samplesInDecay);
        int samplesProcessed = this.previous != null ? this.previous.getSamplesProcessed() : 0;
        double[] output = new double[samplesToGenerate];
        output[0] = this.previous == null ? (this.attackInNanos == 0L ? 1.0 : 0.0) : this.previous.lastSample();
        int totalSamplesInEnvelope = (int)(samplesInAttack + samplesInHold + samplesInDecay);
        int totalSamplesProcessed = samplesProcessed;
        for (int i = 1; i < samplesToGenerate; ++i) {
            if (this.loop && totalSamplesProcessed >= totalSamplesInEnvelope) {
                totalSamplesProcessed = 0;
                if (this.attackInNanos == 0L) {
                    output[i] = 1.0;
                    continue;
                }
                output[i] = 0.0;
                continue;
            }
            if ((double)(++totalSamplesProcessed) <= samplesInAttack) {
                output[i] = output[i - 1] + attackTick;
                continue;
            }
            if ((double)totalSamplesProcessed <= samplesInAttack + samplesInHold) {
                output[i] = 1.0;
                continue;
            }
            if (!((double)totalSamplesProcessed <= samplesInAttack + samplesInHold + samplesInDecay)) continue;
            output[i] = output[i - 1] * decayFactor;
        }
        this.previous = new Levels(Double.NaN, totalSamplesProcessed, output);
        return output;
    }

    @Override
    public void reset() {
        this.previous = null;
    }

    public static void main(String[] args) {
        AttackHoldDecayEnvelope envelope = new AttackHoldDecayEnvelope();
        long oneSecondInNanos = TimeUnit.SECONDS.toNanos(1L);
        int chunkSize = 441;
        double sampleRate = 44100.0;
        long chunkInNanos = (long)(0.01 * (double)oneSecondInNanos);
        int chunk = 0;
        long nanosecondsActivated = 0L;
        long nanosecondsDeactivated = 0L;
        for (int i = 0; i <= 44100; i += chunkSize) {
            double[] envelopeValues;
            if (chunk < 66) {
                nanosecondsActivated += chunkInNanos;
            } else {
                nanosecondsDeactivated += chunkInNanos;
            }
            for (double d : envelopeValues = envelope.levels(nanosecondsActivated, nanosecondsDeactivated, chunkSize, sampleRate)) {
                System.out.printf(Locale.US, "%d,%f%n", chunk, d);
            }
            ++chunk;
        }
    }

    public String toString() {
        return "AttackHoldDecay";
    }
}

