/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.envelopes;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.jevring.frequencies.v2.envelopes.AttackEnvelope;
import net.jevring.frequencies.v2.envelopes.DecayEnvelope;
import net.jevring.frequencies.v2.envelopes.Envelope;
import net.jevring.frequencies.v2.envelopes.Levels;
import net.jevring.frequencies.v2.envelopes.LoopingEnvelope;
import net.jevring.frequencies.v2.envelopes.Phase;

public class AttackDecayEnvelope
implements AttackEnvelope,
DecayEnvelope,
LoopingEnvelope,
Envelope {
    private static final double ZEROISH = 0.01;
    private static final double LN_OF_ZEROISH = Math.log(0.01);
    private volatile long decayInNanos = 200L;
    private volatile long attackInNanos = 0L;
    private volatile boolean loop = false;
    private Levels previous;

    @Override
    public long getAttackInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.attackInNanos);
    }

    @Override
    public void setAttackInMillis(long attackInMillis) {
        this.attackInNanos = TimeUnit.MILLISECONDS.toNanos(attackInMillis);
    }

    @Override
    public long getDecayInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.decayInNanos);
    }

    @Override
    public void setDecayInMillis(long decay) {
        this.decayInNanos = TimeUnit.MILLISECONDS.toNanos(decay);
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public double[] levels(long nanosecondsActivated, long nanosecondsDeactivated, int samplesToGenerate, double sampleRate) {
        double nanosPerSecond = TimeUnit.SECONDS.toNanos(1L);
        double attackInSeconds = (double)this.attackInNanos / nanosPerSecond;
        double samplesInAttack = attackInSeconds * sampleRate;
        double attackTick = 1.0 / samplesInAttack;
        double decayInSeconds = (double)this.decayInNanos / nanosPerSecond;
        double samplesInDecay = decayInSeconds * sampleRate;
        double decayFactor = Math.exp(LN_OF_ZEROISH / samplesInDecay);
        int samplesProcessed = this.previous != null ? this.previous.getSamplesProcessed() : 0;
        double[] output = new double[samplesToGenerate];
        output[0] = this.previous == null ? (this.attackInNanos == 0L ? 1.0 : 0.0) : this.previous.lastSample();
        int totalSamplesInEnvelope = (int)(samplesInAttack + samplesInDecay);
        int totalSamplesProcessed = samplesProcessed;
        for (int i = 1; i < samplesToGenerate; ++i) {
            if (this.loop && totalSamplesProcessed >= totalSamplesInEnvelope) {
                totalSamplesProcessed = 0;
                if (this.attackInNanos == 0L) {
                    output[i] = 1.0;
                    continue;
                }
                output[i] = 0.0;
                continue;
            }
            if ((double)(++totalSamplesProcessed) <= samplesInAttack) {
                output[i] = output[i - 1] + attackTick;
                continue;
            }
            if (!((double)totalSamplesProcessed <= samplesInAttack + samplesInDecay)) continue;
            output[i] = output[i - 1] * decayFactor;
        }
        this.previous = new Levels(Double.NaN, totalSamplesProcessed, output);
        return output;
    }

    @Override
    public Phase phase(long nanosecondsActivated, long nanosecondsDeactivated) {
        if (nanosecondsActivated + nanosecondsDeactivated < this.attackInNanos + this.decayInNanos || this.loop && nanosecondsDeactivated == 0L) {
            return Phase.DECAY;
        }
        return Phase.IDLE;
    }

    @Override
    public void reset() {
        this.previous = null;
    }

    public String toString() {
        return "AttackDecay";
    }

    public static void main(String[] args) {
        AttackDecayEnvelope envelope = new AttackDecayEnvelope();
        envelope.setAttackInMillis(100L);
        envelope.setDecayInMillis(0L);
        envelope.setLoop(false);
        long oneSecondInNanos = TimeUnit.SECONDS.toNanos(1L);
        int chunkSize = 441;
        double sampleRate = 44100.0;
        long chunkInNanos = (long)(0.01 * (double)oneSecondInNanos);
        int chunk = 0;
        long nanosecondsActivated = 0L;
        long nanosecondsDeactivated = 0L;
        for (int i = 0; i <= 44100; i += chunkSize) {
            double[] envelopeValues;
            if (chunk < 66) {
                nanosecondsActivated += chunkInNanos;
            } else {
                nanosecondsDeactivated += chunkInNanos;
            }
            for (double d : envelopeValues = envelope.levels(nanosecondsActivated, nanosecondsDeactivated, chunkSize, sampleRate)) {
                System.out.printf(Locale.US, "%f%n", d);
            }
            ++chunk;
        }
    }
}

