/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.engine;

import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.engine.SamplesToBytesConverter;
import net.jevring.frequencies.v2.math.Clamp;
import net.jevring.frequencies.v2.util.Bytes;

public class StereoBalance
implements SamplesToBytesConverter {
    private final Control balanceControl;

    public StereoBalance(Controls controls) {
        this.balanceControl = controls.getControl("balance");
    }

    @Override
    public byte[] convert(double[] samples) {
        byte[] bytes = new byte[samples.length * 2 * 2];
        int shortsWritten = 0;
        boolean empty = true;
        for (double sample : samples) {
            if (sample != 0.0 && empty) {
                empty = false;
            }
            double balance = Clamp.clamp(this.balanceControl.getCurrentValue(), -1.0, 1.0);
            double leftAmount = 1.0;
            double rightAmount = 1.0;
            if (balance < 0.0) {
                rightAmount += balance;
            } else if (balance > 0.0) {
                leftAmount = 1.0 - balance;
            }
            short leftScaledSample = (short)(sample * leftAmount * 32767.0);
            short rightScaledSample = (short)(sample * rightAmount * 32767.0);
            Bytes.writeShort(leftScaledSample, shortsWritten, bytes);
            Bytes.writeShort(rightScaledSample, shortsWritten += 2, bytes);
            shortsWritten += 2;
        }
        return bytes;
    }
}

