/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects.reverb;

import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.ControlListener;
import net.jevring.frequencies.v2.effects.Coprimes;
import net.jevring.frequencies.v2.effects.DryWetMixer;
import net.jevring.frequencies.v2.effects.Effect;
import net.jevring.frequencies.v2.effects.reverb.AllpassFilter;
import net.jevring.frequencies.v2.effects.reverb.FeedbackCombFilter;
import net.jevring.frequencies.v2.util.SignalEnergyAdder;

public class SchroederReverb
implements Effect {
    private static final double CCRMA_SAMPLE_RATE = 25000.0;
    private final AllpassFilter[] allpassFilters = new AllpassFilter[3];
    private final FeedbackCombFilter[] feedbackCombFilters = new FeedbackCombFilter[4];
    private final Control dryWetMix;

    public SchroederReverb(float sampleRate, Control dryWetMix, Control length) {
        this.dryWetMix = dryWetMix;
        double sampleRateMultiplier = (double)sampleRate / 25000.0;
        final int[] combFilterDelays = Coprimes.findCoprimesAtScale(new int[]{1687, 1601, 2053, 2251}, sampleRateMultiplier);
        int[] allpassDelays = Coprimes.findCoprimesAtScale(new int[]{347, 113, 37}, sampleRateMultiplier);
        this.feedbackCombFilters[0] = new FeedbackCombFilter(sampleRate, combFilterDelays[0], 0.773);
        this.feedbackCombFilters[1] = new FeedbackCombFilter(sampleRate, combFilterDelays[1], 0.802);
        this.feedbackCombFilters[2] = new FeedbackCombFilter(sampleRate, combFilterDelays[2], 0.753);
        this.feedbackCombFilters[3] = new FeedbackCombFilter(sampleRate, combFilterDelays[3], 0.733);
        this.allpassFilters[0] = new AllpassFilter(sampleRate, allpassDelays[0], 0.7);
        this.allpassFilters[1] = new AllpassFilter(sampleRate, allpassDelays[1], 0.7);
        this.allpassFilters[2] = new AllpassFilter(sampleRate, allpassDelays[2], 0.7);
        length.addListener(new ControlListener(){

            @Override
            public void valueChanged(double min, double newValue, double max, Object source) {
                int[] modifiedCombFilterDelays = Coprimes.findCoprimesAtScale(combFilterDelays, newValue);
                for (int i = 0; i < SchroederReverb.this.feedbackCombFilters.length; ++i) {
                    FeedbackCombFilter feedbackCombFilter = SchroederReverb.this.feedbackCombFilters[i];
                    feedbackCombFilter.setDelayInSamples(modifiedCombFilterDelays[i]);
                }
            }
        });
    }

    @Override
    public double[] apply(double[] input) {
        double[] wet = input;
        wet = this.allpassFiltersInSeries(wet);
        wet = this.combFiltersInParallel(wet);
        return DryWetMixer.mix(input, wet, this.dryWetMix.getCurrentValue());
    }

    private double[] allpassFiltersInSeries(double[] wet) {
        for (AllpassFilter allpassFilter : this.allpassFilters) {
            wet = allpassFilter.apply(wet);
        }
        return wet;
    }

    private double[] combFiltersInParallel(double[] input) {
        SignalEnergyAdder combFilterAdder = new SignalEnergyAdder(this.feedbackCombFilters.length, input.length);
        for (FeedbackCombFilter feedbackCombFilter : this.feedbackCombFilters) {
            combFilterAdder.add(feedbackCombFilter.apply(input));
        }
        return combFilterAdder.getOutput();
    }
}

