/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects.reverb;

import net.jevring.frequencies.v2.effects.CircularBuffer;

public class FeedbackCombFilter {
    private final CircularBuffer buffer;
    private final double gain;
    private int delayInSamples;

    public FeedbackCombFilter(float sampleRate, int delayInSamples, double gain) {
        this.buffer = new CircularBuffer(sampleRate, 3.0);
        this.delayInSamples = delayInSamples;
        this.gain = gain;
    }

    public void setDelayInSamples(int delayInSamples) {
        this.delayInSamples = delayInSamples;
    }

    public double[] apply(double[] input) {
        this.buffer.add(input);
        for (int i = 0; i < input.length; ++i) {
            double delayValue = this.gain * this.buffer.get(i - this.delayInSamples);
            this.buffer.increase(i, delayValue);
        }
        return this.buffer.getLast(input.length);
    }

    public void reset() {
        this.buffer.reset();
    }
}

