/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects.reverb;

import net.jevring.frequencies.v2.effects.CircularBuffer;

public class AllpassFilter {
    private final CircularBuffer outputBuffer;
    private final CircularBuffer inputBuffer;
    private final double gain;
    private int delayInSamples;

    public AllpassFilter(double sampleRate, int delayInSamples, double gain) {
        this.outputBuffer = new CircularBuffer(sampleRate, 3.0);
        this.inputBuffer = new CircularBuffer(sampleRate, 3.0);
        this.delayInSamples = delayInSamples;
        this.gain = gain;
    }

    public void setDelayInSamples(int delayInSamples) {
        this.delayInSamples = delayInSamples;
    }

    public double[] apply(double[] input) {
        this.inputBuffer.add(input);
        this.outputBuffer.add(new double[input.length]);
        for (int i = 0; i < input.length; ++i) {
            double value = this.gain * this.inputBuffer.get(i) + this.inputBuffer.get(i - this.delayInSamples) - this.gain * this.outputBuffer.get(i - this.delayInSamples);
            this.outputBuffer.set(i, value);
        }
        return this.outputBuffer.getLast(input.length);
    }
}

