/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects.chorus;

import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.effects.CircularBuffer;
import net.jevring.frequencies.v2.effects.Effect;
import net.jevring.frequencies.v2.oscillators.Oscillator;
import net.jevring.frequencies.v2.waveforms.TriangleWaveform;

public class Chorus
implements Effect {
    private final Control dryWetMix;
    private final TinyModulatedDelay delay1;
    private final TinyModulatedDelay delay2;

    public Chorus(float sampleRate, Control dryWetMix, Control delay1InMilliseconds, Control delay2InMilliseconds, Control rate1, Control rate2, Control depth1, Control depth2) {
        this.dryWetMix = dryWetMix;
        this.delay1 = new TinyModulatedDelay(sampleRate, delay1InMilliseconds, depth1, rate1);
        this.delay2 = new TinyModulatedDelay(sampleRate, delay2InMilliseconds, depth2, rate2);
    }

    @Override
    public double[] apply(double[] input) {
        double[] d1 = this.delay1.apply(input);
        double[] d2 = this.delay2.apply(input);
        double[] output = new double[input.length];
        double dryProportion = this.dryWetMix.getCurrentValue();
        double wetProportion = 1.0 - dryProportion;
        for (int i = 0; i < input.length; ++i) {
            double mix;
            double dry = input[i] * dryProportion;
            double wet = (d1[i] + d2[i]) * wetProportion;
            output[i] = mix = dry + wet;
        }
        return output;
    }

    private static final class TinyModulatedDelay {
        private final TinyDelay tinyDelay;
        private final Control lfoDepth;
        private final Control lfoRate;
        private final Oscillator lfo;

        private TinyModulatedDelay(float sampleRate, Control delayInMilliseconds, Control lfoDepth, Control lfoRate) {
            this.tinyDelay = new TinyDelay(sampleRate, delayInMilliseconds);
            this.lfoDepth = lfoDepth;
            this.lfoRate = lfoRate;
            this.lfo = new Oscillator(sampleRate);
            this.lfo.setWaveform(new TriangleWaveform());
        }

        public double[] apply(double[] input) {
            double[] zeroes = new double[input.length];
            double[] delayModulation = this.lfo.generateSamples(input.length, this.lfoRate.getCurrentValue(), zeroes, zeroes, zeroes, zeroes, zeroes, zeroes, zeroes, zeroes);
            int i = 0;
            while (i < input.length) {
                int n = i++;
                delayModulation[n] = delayModulation[n] * this.lfoDepth.getCurrentValue();
            }
            return this.tinyDelay.apply(input, delayModulation);
        }
    }

    private static final class TinyDelay {
        private final double samplesPerMillisecond;
        private final Control delayInMilliseconds;
        private final CircularBuffer buffer;

        public TinyDelay(double sampleRate, Control delayInMilliseconds) {
            this.delayInMilliseconds = delayInMilliseconds;
            this.samplesPerMillisecond = sampleRate / 1000.0;
            this.buffer = new CircularBuffer(sampleRate, 1.0);
        }

        public double[] apply(double[] input, double[] modulation) {
            double currentDelay = this.delayInMilliseconds.getCurrentValue();
            this.buffer.add(input);
            double[] output = new double[input.length];
            for (int i = 0; i < input.length; ++i) {
                int delayInSamples = (int)Math.round(this.samplesPerMillisecond * (currentDelay + modulation[i]));
                output[i] = this.buffer.get(i - delayInSamples);
            }
            return output;
        }

        public void reset() {
            this.buffer.reset();
        }
    }
}

