/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.effects.Effect;
import net.jevring.frequencies.v2.effects.EffectsChain;
import net.jevring.frequencies.v2.effects.bitcrusher.BitCrusher;
import net.jevring.frequencies.v2.effects.chorus.Chorus;
import net.jevring.frequencies.v2.effects.delay.DelayAndEcho;
import net.jevring.frequencies.v2.effects.reverb.SchroederReverb;

public class FullEffectsChain
implements EffectsChain {
    private final List<Effect> chain = new ArrayList<Effect>();
    private final DelayAndEcho delayAndEcho;
    private final SchroederReverb reverb;
    private final BitCrusher bitCrusher;
    private final Chorus chorus;

    public FullEffectsChain(Controls controls, float sampleRate) {
        this.bitCrusher = new BitCrusher(controls.getControl("bit-crusher-downsampling"), controls.getControl("bit-crusher-resolution"));
        this.delayAndEcho = new DelayAndEcho(sampleRate, controls.getControl("delay-dry-wet-mix"), controls.getControl("delay-in-milliseconds"), controls.getControl("delay-decay"));
        this.chorus = new Chorus(sampleRate, controls.getControl("chorus-dry-wet-mix"), controls.getControl("chorus-delay-in-milliseconds-1"), controls.getControl("chorus-delay-in-milliseconds-2"), controls.getControl("chorus-rate-1"), controls.getControl("chorus-rate-2"), controls.getControl("chorus-depth-1"), controls.getControl("chorus-depth-2"));
        this.reverb = new SchroederReverb(sampleRate, controls.getControl("reverb-dry-wet-mix"), controls.getControl("reverb-length"));
        this.chain.add(this.delayAndEcho);
        this.chain.add(this.reverb);
    }

    @Override
    public double[] apply(double[] samples) {
        for (Effect effect : this.chain) {
            samples = effect.apply(samples);
        }
        return samples;
    }
}

