/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.effects;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;

public class Coprimes {
    public static int[] findCoprimesAtScale(int[] input, double scale) {
        int mutatorStep = 0;
        int[] mutable = Coprimes.scale(input, scale);
        for (int attempt = 0; attempt <= 500; ++attempt) {
            if (Coprimes.coprime(mutable)) {
                System.out.printf(Locale.US, "Found coprimes for scale %.3f after %3d attempts -> %s%n", scale, attempt, Arrays.toString(mutable));
                return mutable;
            }
            int n = mutatorStep++ % mutable.length;
            mutable[n] = mutable[n] + 1;
        }
        System.err.println("Could not find coprimes after 500 attempts at scale " + scale);
        return input;
    }

    private static int[] scale(int[] is, double scale) {
        int[] output = Arrays.copyOf(is, is.length);
        for (int i = 0; i < output.length; ++i) {
            output[i] = (int)Math.round((double)output[i] * scale);
        }
        return output;
    }

    private static boolean coprime(int[] input) {
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < input.length; ++j) {
                if (i == j || Coprimes.coprime(input[i], input[j])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean coprime(int a, int b) {
        return BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).equals(BigInteger.ONE);
    }

    public static void main(String[] args) {
        double scale;
        int[] baseDelays = new int[]{1687, 1601, 2053, 2251};
        for (double s = scale = 1.0; s < 5.0; s += 0.01) {
            Coprimes.findCoprimesAtScale(baseDelays, s);
        }
    }
}

