/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.control.curves.Curve;

public class Controls {
    private final Map<String, DiscreteControl> discreteControls = new HashMap<String, DiscreteControl>();
    private final Map<String, BooleanControl> booleanControls = new HashMap<String, BooleanControl>();
    private final Map<String, Control> controls = new HashMap<String, Control>();

    private void assertNew(String key) {
        if (this.controls.containsKey(key)) {
            throw new AssertionError((Object)("Key " + key + " already exists as a control"));
        }
        if (this.discreteControls.containsKey(key)) {
            throw new AssertionError((Object)("Key " + key + " already exists as a discrete control"));
        }
        if (this.booleanControls.containsKey(key)) {
            throw new AssertionError((Object)("Key " + key + " already exists as a boolean control"));
        }
    }

    public BooleanControl createBooleanControl(String key, boolean defaultValue) {
        this.assertNew(key);
        BooleanControl control = new BooleanControl(key, defaultValue);
        if (this.booleanControls.putIfAbsent(key, control) != null) {
            throw new IllegalArgumentException("Key " + key + " already mapped a control");
        }
        return control;
    }

    public DiscreteControl createDiscreteControl(String key, List<String> allowedValues, String defaultValue) {
        this.assertNew(key);
        DiscreteControl control = new DiscreteControl(key, allowedValues, defaultValue);
        if (this.discreteControls.putIfAbsent(key, control) != null) {
            throw new IllegalArgumentException("Key " + key + " already mapped a control");
        }
        return control;
    }

    public Control createControl(String key, double min, double max, double start, Curve curve) {
        return this.createControl(key, min, max, start, curve, false);
    }

    public Control createControl(String key, double min, double max, double start, Curve curve, boolean round) {
        Control control = new Control(key, min, start, max, curve, round);
        this.assertNew(key);
        if (this.controls.putIfAbsent(key, control) != null) {
            throw new IllegalArgumentException("Key " + key + " already mapped a control");
        }
        return control;
    }

    public Control getControl(String key) {
        return this.controls.get(key);
    }

    public DiscreteControl getDiscreteControl(String key) {
        return this.discreteControls.get(key);
    }

    public BooleanControl getBooleanControl(String key) {
        return this.booleanControls.get(key);
    }

    public void resetSynthesizer(Object source) {
        for (Control control : this.controls.values()) {
            if (control.getKey().contains("sequencer-")) continue;
            control.reset(source);
        }
        for (DiscreteControl discreteControl : this.discreteControls.values()) {
            if (discreteControl.getKey().contains("sequencer-")) continue;
            discreteControl.reset(source);
        }
        for (BooleanControl booleanControl : this.booleanControls.values()) {
            if (booleanControl.getKey().contains("sequencer-")) continue;
            booleanControl.reset(source);
        }
    }

    public void resetSequencer(Object source) {
        for (Control control : this.controls.values()) {
            if (!control.getKey().contains("sequencer-")) continue;
            control.reset(source);
        }
        for (DiscreteControl discreteControl : this.discreteControls.values()) {
            if (!discreteControl.getKey().contains("sequencer-")) continue;
            discreteControl.reset(source);
        }
        for (BooleanControl booleanControl : this.booleanControls.values()) {
            if (!booleanControl.getKey().contains("sequencer-")) continue;
            booleanControl.reset(source);
        }
    }

    public Map<String, Control> getControls() {
        return this.controls;
    }

    public Map<String, DiscreteControl> getDiscreteControls() {
        return this.discreteControls;
    }

    public Map<String, BooleanControl> getBooleanControls() {
        return this.booleanControls;
    }
}

