/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.control;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v2.control.DiscreteControlListener;

public class BooleanControl {
    private final List<DiscreteControlListener<Boolean>> listeners = new ArrayList<DiscreteControlListener<Boolean>>();
    private final boolean defaultValue;
    private volatile boolean value;
    private final String key;

    BooleanControl(String key, boolean defaultValue) {
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.key = key;
    }

    public void set(boolean myValue, Object source) {
        this.value = myValue;
        this.updateListeners(source);
    }

    private void updateListeners(Object source) {
        for (DiscreteControlListener<Boolean> listener : this.listeners) {
            listener.valueChanged(this.value, source);
        }
    }

    public void reset(Object source) {
        this.value = this.defaultValue;
        this.updateListeners(source);
    }

    public String getKey() {
        return this.key;
    }

    public boolean get() {
        return this.value;
    }

    public void addListener(DiscreteControlListener<Boolean> listener) {
        this.listeners.add(listener);
        listener.valueChanged(this.value, this);
    }

    public void deleteListener(DiscreteControlListener<String> listener) {
        this.listeners.remove(listener);
    }

    public static BooleanControl alwaysTrue() {
        return new BooleanControl("always-true", true);
    }
}

