/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.configuration;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.jevring.frequencies.v2.configuration.Randomizer;
import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrix;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;

public class DefaultRandomizer
implements Randomizer {
    private static final Set<String> controlsExemptFromRandomization = Set.of("balance", "clip", "overdrive-volume", "velocity-sensitive-keys", "glide-length", "input-mode", "delay-dry-wet-mix", "pitch-bend", "volume-envelope-loop", "filter-envelope-loop", "legato", "euclidean-sequencer-active", "sequencer-active", "arpeggiator-active", "sequencer-listen", "primary-oscillator-phase-shift", "secondary-oscillator-phase-shift");
    private static final Set<ModulationTarget> modulationTargetsExemptFromRandomization = EnumSet.of(ModulationTarget.PRIMARY_OSCILLATOR_PHASE_SHIFT, ModulationTarget.SECONDARY_OSCILLATOR_PHASE_SHIFT);

    @Override
    public void randomizeSequencer(Controls controls) {
        for (Control control : controls.getControls().values()) {
            if (!control.getKey().contains("sequencer-")) continue;
            control.set(0.0, Math.random(), 1.0, this);
        }
        for (DiscreteControl discreteControl : controls.getDiscreteControls().values()) {
            if (!discreteControl.getKey().contains("sequencer-")) continue;
            int item = (int)Math.round(Math.random() * (double)(discreteControl.getAllowedValues().size() - 1));
            discreteControl.set(discreteControl.getAllowedValues().get(item), this);
        }
        Random random = new Random();
        for (BooleanControl booleanControl : controls.getBooleanControls().values()) {
            if (controlsExemptFromRandomization.contains(booleanControl.getKey()) || !booleanControl.getKey().contains("sequencer-")) continue;
            booleanControl.set(random.nextBoolean(), this);
        }
    }

    @Override
    public void randomizeSynthesizer(Controls controls, ModulationMatrix modulationMatrix) {
        int modulationMatrixSlots = (int)(Math.random() * 10.0);
        ModulationSource[] modulationSources = ModulationSource.values();
        List modulationTargets = Arrays.stream(ModulationTarget.values()).filter(Predicate.not(modulationTargetsExemptFromRandomization::contains)).collect(Collectors.toList());
        for (int i = 0; i < modulationMatrixSlots; ++i) {
            modulationMatrix.add(modulationSources[(int)(Math.random() * (double)(modulationSources.length - 1))], (ModulationTarget)((Object)modulationTargets.get((int)(Math.random() * (double)(modulationTargets.size() - 1)))));
        }
        for (Control control : controls.getControls().values()) {
            if (control.getKey().contains("sequencer-") || controlsExemptFromRandomization.contains(control.getKey())) continue;
            control.set(0.0, Math.random(), 1.0, this);
        }
        for (DiscreteControl discreteControl : controls.getDiscreteControls().values()) {
            if (discreteControl.getKey().contains("sequencer-") || controlsExemptFromRandomization.contains(discreteControl.getKey())) continue;
            discreteControl.set(discreteControl.getAllowedValues().get((int)(Math.random() * (double)(discreteControl.getAllowedValues().size() - 1))), this);
        }
        Random random = new Random();
        for (BooleanControl booleanControl : controls.getBooleanControls().values()) {
            if (booleanControl.getKey().contains("sequencer-") || controlsExemptFromRandomization.contains(booleanControl.getKey())) continue;
            booleanControl.set(random.nextBoolean(), this);
        }
    }
}

