/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationWriter
implements AutoCloseable {
    private final Map<String, List<String>> data = new LinkedHashMap<String, List<String>>();
    private boolean closed = false;
    private final String version;
    private final File file;

    public ConfigurationWriter(String version, File file) {
        this.version = version;
        this.file = file;
    }

    public void add(String section, String setting) {
        this.data.computeIfAbsent(section, ignored -> new ArrayList()).add(setting);
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            throw new IllegalStateException("Already closed");
        }
        this.closed = true;
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.file)));){
            out.println("# Created at " + ZonedDateTime.now());
            out.println("# Created by <Your name and email and blog and soundcloud etc here>");
            out.println("[version]");
            out.println(this.version);
            out.println();
            for (Map.Entry<String, List<String>> entry : this.data.entrySet()) {
                String section = entry.getKey();
                List<String> settings = entry.getValue();
                out.print("[");
                out.print(section);
                out.print("]");
                out.println();
                settings.stream().sorted().forEach(out::println);
                out.println();
            }
            out.flush();
        }
    }
}

