/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v2.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.jevring.frequencies.v2.configuration.ConfigurationReader;
import net.jevring.frequencies.v2.configuration.ConfigurationWriter;
import net.jevring.frequencies.v2.configuration.NiceRandomizer;
import net.jevring.frequencies.v2.configuration.Randomizer;
import net.jevring.frequencies.v2.configuration.StoredConfigurationCallback;
import net.jevring.frequencies.v2.control.BooleanControl;
import net.jevring.frequencies.v2.control.Control;
import net.jevring.frequencies.v2.control.Controls;
import net.jevring.frequencies.v2.control.DiscreteControl;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrix;
import net.jevring.frequencies.v2.modulation.matrix.ModulationMatrixRow;
import net.jevring.frequencies.v2.modulation.matrix.ModulationSource;
import net.jevring.frequencies.v2.modulation.matrix.ModulationTarget;

public class Configuration {
    private final Randomizer randomizer = new NiceRandomizer();
    private final File configurationsDirectory;
    private final ModulationMatrix modulationMatrix;
    private final Controls controls;

    public Configuration(ModulationMatrix modulationMatrix, Controls controls, File dotConfigDirectory) {
        this.configurationsDirectory = new File(dotConfigDirectory, "configurations");
        this.modulationMatrix = modulationMatrix;
        this.controls = controls;
    }

    public File ensureConfigurationDirectoryExists() {
        if (!this.configurationsDirectory.exists() && !this.configurationsDirectory.mkdirs()) {
            System.err.println("Couldn't create dir " + this.configurationsDirectory.getAbsolutePath());
        }
        return this.configurationsDirectory;
    }

    public void save(File output) {
        try (ConfigurationWriter writer = new ConfigurationWriter("3", output);){
            Object control;
            for (ModulationMatrixRow modulationMatrixRow : this.modulationMatrix.getModulationConfig(false)) {
                writer.add("modulation-matrix", modulationMatrixRow.source().name() + "," + modulationMatrixRow.target().name());
            }
            for (Map.Entry entry : new TreeMap<String, DiscreteControl>(this.controls.getDiscreteControls()).entrySet()) {
                control = (DiscreteControl)entry.getValue();
                String value = ((DiscreteControl)control).get();
                writer.add("discrete-controls", String.format(Locale.US, "%s,%s", entry.getKey(), value));
            }
            for (Map.Entry entry : new TreeMap<String, BooleanControl>(this.controls.getBooleanControls()).entrySet()) {
                control = (BooleanControl)entry.getValue();
                boolean value = ((BooleanControl)control).get();
                writer.add("discrete-controls", String.format(Locale.US, "%s,%b", entry.getKey(), value));
            }
            for (Map.Entry entry : new TreeMap<String, Control>(this.controls.getControls()).entrySet()) {
                control = (Control)entry.getValue();
                writer.add("controls", String.format(Locale.US, "%s,%f", entry.getKey(), ((Control)control).getCurrentValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        this.resetSynthesizer();
        this.resetSequencer();
    }

    public void resetSequencer() {
        this.controls.resetSequencer(this);
    }

    public void resetSynthesizer() {
        this.modulationMatrix.clear();
        this.controls.resetSynthesizer(this);
    }

    public void load(InputStream inputStream) {
        this.reset();
        this.justLoad(inputStream);
    }

    private void justLoad(InputStream inputStream) {
        try (InputStream is = inputStream;){
            ConfigurationReader.read(is, new StoredConfigurationCallback(){
                private final Map<String, Object> values = new HashMap<String, Object>();
                private final Map<String, List<String>> modulationMatrixValues = new HashMap<String, List<String>>();

                @Override
                public void handle(String version, String section, String line) {
                    try {
                        String[] parts = line.split(",");
                        String key = Configuration.this.compatibilityMapper(parts[0]);
                        if ("controls".equals(section)) {
                            double value;
                            if (parts.length == 5) {
                                value = Double.parseDouble(parts[3]);
                            } else if (parts.length == 2) {
                                value = Double.parseDouble(parts[1]);
                            } else {
                                System.out.println("Skipping unknown format: " + line);
                                return;
                            }
                            this.values.put(key, value);
                        } else if ("discrete-controls".equals(section)) {
                            String value = Configuration.this.compatibilityMapper(parts[1]);
                            if (!"3".equals(version) && key.endsWith("-waveform")) {
                                String oscillator = key.substring(0, key.length() - 9);
                                switch (value) {
                                    case "3StepUp": {
                                        this.values.put(oscillator + "-quantization-steps", 1);
                                        this.values.put(oscillator + "-variable-waveform", 2);
                                        break;
                                    }
                                    case "4StepUp": {
                                        this.values.put(oscillator + "-quantization-steps", 2);
                                        this.values.put(oscillator + "-variable-waveform", 2);
                                        break;
                                    }
                                    case "8StepUp": {
                                        this.values.put(oscillator + "-quantization-steps", 4);
                                        this.values.put(oscillator + "-variable-waveform", 2);
                                        break;
                                    }
                                    case "3Pyramid": {
                                        this.values.put(oscillator + "-quantization-steps", 1);
                                        this.values.put(oscillator + "-variable-waveform", 1);
                                        break;
                                    }
                                    case "5Pyramid": {
                                        this.values.put(oscillator + "-quantization-steps", 3);
                                        this.values.put(oscillator + "-variable-waveform", 1);
                                        break;
                                    }
                                    case "9Pyramid": {
                                        this.values.put(oscillator + "-quantization-steps", 5);
                                        this.values.put(oscillator + "-variable-waveform", 1);
                                        break;
                                    }
                                    case "Saw": {
                                        this.values.put(oscillator + "-quantization-steps", 16);
                                        this.values.put(oscillator + "-variable-waveform", 2);
                                        break;
                                    }
                                    case "Square": {
                                        this.values.put(oscillator + "-quantization-steps", 16);
                                        this.values.put(oscillator + "-variable-waveform", 3);
                                        break;
                                    }
                                    case "Triangle": {
                                        this.values.put(oscillator + "-quantization-steps", 16);
                                        this.values.put(oscillator + "-variable-waveform", 1);
                                        break;
                                    }
                                    case "Sine": {
                                        this.values.put(oscillator + "-quantization-steps", 16);
                                        this.values.put(oscillator + "-variable-waveform", 0);
                                    }
                                }
                                return;
                            }
                            this.values.put(key, value);
                        } else if ("modulation-matrix".equals(section)) {
                            this.modulationMatrixValues.computeIfAbsent(parts[0], ignored -> new ArrayList()).add(parts[1]);
                        } else {
                            System.err.printf("UNKNOWN: version: %s, section: %s, setting: %s%n", version, section, line);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void loadComplete() {
                    Object value;
                    Object control;
                    if ((Double)this.values.getOrDefault("delay-in-milliseconds", 0.0) == 0.0) {
                        this.values.put("delay-decay", 0.25);
                        this.values.put("delay-dry-wet-mix", 1);
                    }
                    for (ModulationSource modulationSource : ModulationSource.values()) {
                        for (ModulationTarget modulationTarget : ModulationTarget.values()) {
                            List<String> modulationTargets = this.modulationMatrixValues.get(modulationSource.name());
                            if (modulationTargets == null || !modulationTargets.contains(modulationTarget.name())) continue;
                            Configuration.this.modulationMatrix.add(modulationSource, modulationTarget);
                        }
                    }
                    for (Map.Entry entry : Configuration.this.controls.getDiscreteControls().entrySet()) {
                        String key = (String)entry.getKey();
                        control = (DiscreteControl)entry.getValue();
                        value = this.values.get(key);
                        Object object = value;
                        if (!(object instanceof String)) continue;
                        String s = (String)object;
                        try {
                            ((DiscreteControl)control).set(s, this);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                    }
                    for (Map.Entry entry : Configuration.this.controls.getControls().entrySet()) {
                        String key = (String)entry.getKey();
                        control = (Control)entry.getValue();
                        value = this.values.get(key);
                        Object e = value;
                        if (!(e instanceof Double)) continue;
                        Double d = (Double)e;
                        ((Control)control).setRaw(d);
                    }
                    for (Map.Entry entry : Configuration.this.controls.getBooleanControls().entrySet()) {
                        String key = (String)entry.getKey();
                        if (key.endsWith("active") || key.endsWith("listen")) continue;
                        control = (BooleanControl)entry.getValue();
                        value = this.values.get(key);
                        Object e = value;
                        if (!(e instanceof String)) continue;
                        String s = (String)e;
                        try {
                            ((BooleanControl)control).set(Boolean.parseBoolean(s), this);
                        }
                        catch (RuntimeException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void randomize() {
        this.resetSynthesizer();
        this.resetSequencer();
        this.randomizer.randomize(this.controls, this.modulationMatrix);
    }

    public void randomizeSequencer() {
        this.resetSequencer();
        this.randomizer.randomizeSequencer(this.controls);
    }

    public void randomizeSynthesizer() {
        this.resetSynthesizer();
        this.randomizer.randomizeSynthesizer(this.controls, this.modulationMatrix);
    }

    private String compatibilityMapper(String input) {
        return switch (input) {
            case "Krajeski4PoleLadderFilter" -> "Stilson4PoleLadderFilter";
            case "Open303Sawtooth", "Open303MoogSawtooth", "Open303MoogSaw", "SawtoothUp", "SawtoothDown", "SawUp", "SawDown" -> "Saw";
            case "Open303Square", "Pulse" -> "Square";
            case "Sinus" -> "Sine";
            case "filter-envelope-to-filter-cutoff-frequency-depth" -> "filter-envelope-depth";
            default -> input;
        };
    }
}

