/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;

public class Test {
    public static void xmain(String[] args) {
        int i = -253;
        System.out.println(i);
        System.out.println(i >> 1);
        System.out.println(i & Test.getPattern(0));
        System.out.println(i & Test.getPattern(1));
        System.out.println(i & Test.getPattern(2));
        System.out.println(i & Test.getPattern(3));
        System.out.println(-126);
    }

    private static int getPattern(int offset) {
        switch (offset) {
            case 0: {
                return 255;
            }
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFF0000;
            }
            case 3: {
                return -16777216;
            }
        }
        throw new IllegalArgumentException("Max offset = 4 (32 bit integers)");
    }

    public static void xxmain(String[] args) {
        int value = 257;
        byte b1 = (byte)(value & 0xFF);
        byte b2 = (byte)(value >> 8 & 0xFF);
        int newValue = (b2 & 0xFF) << 8 | (b1 & 0xFF) << 0;
        System.out.println("b1: " + b1);
        System.out.println("b2: " + b2);
        System.out.println("value = " + value);
        System.out.println("newValue = " + newValue);
    }

    public static void main(String[] args) {
        try {
            float frameRate = 44100.0f;
            int channels = 2;
            double duration = 1.0;
            int sampleBytes = 2;
            int frameBytes = sampleBytes * channels;
            AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, frameRate, 16, channels, frameBytes, frameRate, true);
            int nFrames = (int)Math.ceil((double)frameRate * duration);
            int nSamples = nFrames * channels;
            int nBytes = nSamples * sampleBytes;
            ByteBuffer data = ByteBuffer.allocate(nBytes);
            double freq = 440.0;
            for (int i = 0; i < nFrames; ++i) {
                double value = Math.sin((double)i / (double)frameRate * freq * 2.0 * Math.PI) * 32767.0;
                for (int c = 0; c < channels; ++c) {
                    int index = (i * channels + c) * sampleBytes;
                    data.putShort(index, (short)value);
                }
            }
            AudioInputStream stream = new AudioInputStream(new ByteArrayInputStream(data.array()), format, nFrames * 2);
            Clip clip = AudioSystem.getClip();
            clip.open(stream);
            clip.start();
            clip.drain();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

