/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.tests;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jevring.frequencies.v1.output.LineOutput;
import net.jevring.frequencies.v1.output.SimplePlayer;
import net.jevring.frequencies.v1.sound.ContinuousSound;
import net.jevring.frequencies.v1.sound.FixedSound;
import net.jevring.frequencies.v1.ui.ByteArrayGraph;
import net.jevring.frequencies.v1.waveforms.Waveform;
import net.jevring.frequencies.v1.waveforms.sawtooth.SawtoothWaveform;
import net.jevring.frequencies.v1.waveforms.sine.SineWaveform;
import net.jevring.frequencies.v1.waveforms.square.SquareWaveform;
import net.jevring.frequencies.v1.waveforms.squareroot.SquareRootWaveform;
import net.jevring.frequencies.v1.waveforms.triangle.TriangleWaveform;
import net.jevring.frequencies.v2.ui.GridBadLayoutUtils;
import net.jevring.frequencies.v2.ui.SwingUtils;

public class SoundBoard
extends JPanel {
    private final LineOutput out = new LineOutput();
    private volatile WaveformCreator waveformCreator = new WaveformCreator(SineWaveform.class);
    private volatile Waveform currentWaveform;

    public SoundBoard() {
        this.setLayout(new GridBagLayout());
        final AtomicBoolean continuous = new AtomicBoolean();
        final ByteArrayGraph graph = new ByteArrayGraph();
        final JSlider frequency = new JSlider(100, 600, 440);
        final JSpinner bitRate = new JSpinner(new SpinnerNumberModel(8, 8, 32, 8));
        bitRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SoundBoard.this.changeWaveform(frequency, graph, bitRate);
            }
        });
        final JTextField frequencyValue = new JTextField();
        frequency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SoundBoard.this.currentWaveform.setFrequency(frequency.getValue());
                frequencyValue.setText(String.valueOf(frequency.getValue()) + " Hz");
                SoundBoard.this.updateGraph(graph);
                SoundBoard.this.revalidate();
                SoundBoard.this.repaint();
            }
        });
        JButton play = new JButton("Play!");
        play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SimplePlayer.play(new FixedSound(SoundBoard.this.currentWaveform, 1000L));
                }
                catch (LineUnavailableException e1) {
                    e1.printStackTrace();
                }
            }
        });
        final JButton on = new JButton("Turn on");
        on.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("Turn on".equals(on.getText())) {
                    continuous.set(true);
                    SoundBoard.this.out.connect(new ContinuousSound(SoundBoard.this.currentWaveform));
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                System.out.println("Commencing playback");
                                SoundBoard.this.out.play();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    t.start();
                    on.setText("Turn off");
                } else {
                    continuous.set(false);
                    SoundBoard.this.out.stop();
                    on.setText("Turn on");
                }
            }
        });
        DefaultComboBoxModel<Class<TriangleWaveform>> waveforms = new DefaultComboBoxModel<Class<TriangleWaveform>>();
        waveforms.addElement(SineWaveform.class);
        waveforms.addElement(SawtoothWaveform.class);
        waveforms.addElement(SquareRootWaveform.class);
        waveforms.addElement(SquareWaveform.class);
        waveforms.addElement(TriangleWaveform.class);
        JComboBox waveform = new JComboBox(waveforms);
        waveform.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    System.out.println("Setting sound creator for class " + e.getItem());
                    SoundBoard.this.waveformCreator = new WaveformCreator((Class)e.getItem());
                    SoundBoard.this.changeWaveform(frequency, graph, bitRate);
                }
            }
        });
        this.add((Component)graph, GridBadLayoutUtils.gbc(0, 0, 4, 1, 1.0, 1.0));
        this.add((Component)frequency, GridBadLayoutUtils.gbc(0, 1, 1, 1, 1.0, 0.0));
        this.add((Component)frequencyValue, GridBadLayoutUtils.gbc(1, 1, 1, 1, 0.0, 0.0));
        this.add((Component)bitRate, GridBadLayoutUtils.gbc(2, 1, 1, 1, 0.0, 0.0));
        this.add(waveform, GridBadLayoutUtils.gbc(0, 2, 4, 1, 0.0, 0.0));
        this.add((Component)play, GridBadLayoutUtils.gbc(0, 3, 4, 1, 0.0, 0.0));
        this.add((Component)on, GridBadLayoutUtils.gbc(0, 4, 4, 1, 0.0, 0.0));
        this.changeWaveform(frequency, graph, bitRate);
        frequencyValue.setText(String.valueOf(frequency.getValue()) + " Hz");
    }

    public static void main(String[] args) {
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            Line.Info[] sourceLineInfo;
            Mixer mixer = AudioSystem.getMixer(info);
            System.out.println("For mixer " + info.getDescription());
            System.out.println("These are the supported formats");
            for (Line.Info info2 : sourceLineInfo = mixer.getSourceLineInfo()) {
                if (!(info2 instanceof DataLine.Info)) continue;
                for (AudioFormat audioFormat : ((DataLine.Info)info2).getFormats()) {
                    System.out.println("audioFormat = " + audioFormat);
                }
            }
        }
        SwingUtils.showWindowFor("Sound board", new SoundBoard(), false);
    }

    private void changeWaveform(JSlider frequency, ByteArrayGraph graph, JSpinner bitRate) {
        this.currentWaveform = this.waveformCreator.create(frequency.getValue(), (Integer)bitRate.getValue());
        this.updateGraph(graph);
        this.revalidate();
        this.repaint();
    }

    private void updateGraph(ByteArrayGraph graph) {
        FixedSound sound = new FixedSound(this.currentWaveform, 50L);
        graph.update(sound.getData(), sound.getBitsPerSample());
    }

    private static final class WaveformCreator {
        private final Class<? extends Waveform> clazz;

        private WaveformCreator(Class<? extends Waveform> clazz) {
            this.clazz = clazz;
        }

        private Waveform create(int frequency, int bitRate) {
            try {
                Constructor<? extends Waveform> constructor = this.clazz.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return constructor.newInstance(44100, bitRate, frequency);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new AssertionError((Object)e);
            }
        }
    }
}

