/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.tests;

import javax.sound.sampled.LineUnavailableException;
import javax.swing.SwingUtilities;
import net.jevring.frequencies.v1.output.SimplePlayer;
import net.jevring.frequencies.v1.sound.CombinedWaveform;
import net.jevring.frequencies.v1.sound.FixedSound;
import net.jevring.frequencies.v1.ui.ByteArrayGraph;
import net.jevring.frequencies.v1.waveforms.sine.SineWaveform;
import net.jevring.frequencies.v2.ui.SwingUtils;

public class CombinedWaveformTest {
    public static void main(String[] args) {
        int bitsPerSample = 8;
        CombinedWaveform sc = new CombinedWaveform(44100, bitsPerSample);
        sc.add(new SineWaveform(44100, bitsPerSample, 100));
        sc.add(new SineWaveform(44100, bitsPerSample, 500));
        final FixedSound sound = new FixedSound(sc, 30000L);
        final ByteArrayGraph byteArrayGraph = new ByteArrayGraph();
        SwingUtils.showWindowFor("Byte array graph", byteArrayGraph, false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                byteArrayGraph.update(sound.getData(), sound.getBitsPerSample());
            }
        });
        try {
            SimplePlayer.play(sound);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }
}

