/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.sound;

import javax.sound.sampled.AudioFormat;
import net.jevring.frequencies.v1.sound.Signal;
import net.jevring.frequencies.v1.waveforms.Waveform;
import net.jevring.frequencies.v2.util.Bytes;

public class ContinuousSound
implements Signal {
    private final Waveform waveform;
    private final int bytesPerSample;
    private int step = 0;

    public ContinuousSound(Waveform waveform) {
        this.waveform = waveform;
        this.bytesPerSample = waveform.getBitsPerSample() / 8;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.waveform.getAudioFormat();
    }

    @Override
    public byte[] getSound() {
        return this.getSingleSound();
    }

    private byte[] getSingleSound() {
        this.step += this.bytesPerSample;
        if ((float)this.step > this.waveform.getSampleRate() / (float)this.waveform.getFrequency() || this.step < 0) {
            System.out.println("Reset at " + this.step);
            this.step = 0;
        }
        int value = this.waveform.valueAtStep(this.step);
        return Bytes.convertToBytes(value, this.bytesPerSample);
    }

    private byte[] getSoundPiece() {
        int stepsPerChunk = 4;
        byte[] data = new byte[stepsPerChunk * this.bytesPerSample];
        for (int i = 0; i < stepsPerChunk; i += this.bytesPerSample) {
            this.step += this.bytesPerSample;
            int value = this.waveform.valueAtStep(this.step);
            if (this.waveform.getBitsPerSample() == 8) {
                data[i] = (byte)value;
                continue;
            }
            if (this.waveform.getBitsPerSample() != 16) continue;
            data[i + 1] = (byte)(value & 0xFF);
            data[i] = (byte)(value >> 8 & 0xFF);
        }
        if ((float)this.step > this.waveform.getSampleRate() * (float)this.bytesPerSample * (float)this.waveform.getFrequency()) {
            System.out.println("Reset");
            this.step = 0;
        }
        return data;
    }

    private byte[] getSoundChunk() {
        System.out.println("ContinuousSound.getSound");
        byte[] data = new byte[(int)(this.waveform.getSampleRate() * (float)this.bytesPerSample)];
        for (int i = 0; i < data.length; i += this.bytesPerSample) {
            int value = this.waveform.valueAtStep(i);
            if (this.waveform.getBitsPerSample() == 8) {
                data[i] = (byte)value;
                continue;
            }
            if (this.waveform.getBitsPerSample() != 16) continue;
            data[i + 1] = (byte)(value & 0xFF);
            data[i] = (byte)(value >> 8 & 0xFF);
        }
        return data;
    }

    public int getBitsPerSample() {
        return this.waveform.getBitsPerSample();
    }
}

