/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.sound;

import java.util.ArrayList;
import java.util.List;
import net.jevring.frequencies.v1.waveforms.Waveform;

public class CombinedWaveform
extends Waveform {
    private final List<Waveform> waveforms = new ArrayList<Waveform>();

    public CombinedWaveform(int sampleRate, int bitsPerSample) {
        super(sampleRate, bitsPerSample, 0);
    }

    @Override
    public int valueAtStep(int i) {
        int s = 0;
        for (Waveform waveform : this.waveforms) {
            s += waveform.valueAtStep(i) / this.waveforms.size();
        }
        return s;
    }

    public void add(Waveform waveform) {
        if (waveform.getBitsPerSample() != this.bitsPerSample) {
            throw new IllegalArgumentException("Bits per sample don't match. Got " + waveform.getBitsPerSample() + " bit expected " + this.bitsPerSample);
        }
        if (waveform.getSampleRate() != this.sampleRate) {
            throw new IllegalArgumentException("Sample rate doesn't match. Got " + waveform.getSampleRate() + " bit expected " + this.sampleRate);
        }
        this.waveforms.add(waveform);
    }

    public void remove(Waveform waveform) {
        this.waveforms.remove(waveform);
    }
}

