/*
 * Decompiled with CFR 0.152.
 */
package net.jevring.frequencies.v1.continuous.signals;

import net.jevring.frequencies.v1.sound.FixedSound;
import net.jevring.frequencies.v1.sound.Signal;
import net.jevring.frequencies.v1.waveforms.sine.SineWaveform;

public class SineWaveSignal
extends FixedSound
implements Signal {
    public SineWaveSignal(int sampleRate, int bitsPerSample, int frequency) {
        super(new SineWaveform(sampleRate, bitsPerSample, frequency), 0L);
    }

    @Override
    public byte[] getSound() {
        int bytesPerSample = this.waveform.getBitsPerSample() / 8;
        byte[] data = new byte[(int)((double)(this.waveform.getSampleRate() * (float)bytesPerSample) / (double)this.waveform.getFrequency())];
        for (int i = 0; i < data.length; i += bytesPerSample) {
            double angle = (double)((float)i / (this.waveform.getSampleRate() / (float)this.waveform.getFrequency())) * 2.0 * Math.PI;
            int value = (int)(Math.sin(angle /= (double)bytesPerSample) * (Math.pow(2.0, this.waveform.getBitsPerSample() - 1) - 1.0));
            if (this.waveform.getBitsPerSample() == 8) {
                data[i] = (byte)value;
                continue;
            }
            if (this.waveform.getBitsPerSample() != 16) continue;
            data[i + 1] = (byte)(value & 0xFF);
            data[i] = (byte)(value >> 8 & 0xFF);
        }
        return data;
    }
}

